<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
* @copyright 2021 Talldude Networks, LLC.
*/

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: form_field_update_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCore_form_field_update_save($_post, $_user, $_conf)
{
    global $_mods;
    jrUser_master_only();
    jrCore_set_flag('master_html_trusted', 1);
    jrCore_form_validate($_post);
    if (!isset($_post['field_module']) || !isset($_mods["{$_post['field_module']}"])) {
        jrCore_set_form_notice('error', 'Invalid module');
        jrCore_form_result();
    }
    if (!isset($_post['field_view']) || strlen($_post['field_view']) === 0) {
        jrCore_set_form_notice('error', 'Invalid view');
        jrCore_form_result();
    }
    if (isset($_post['required']) && $_post['required'] == 'on') {
        $_post['required'] = 1;
    }
    else {
        $_post['required'] = 0;
    }
    if (isset($_post['active']) && $_post['active'] == 'on') {
        $_post['active'] = 1;
    }
    else {
        $_post['active'] = 0;
    }
    $mod = $_post['field_module'];
    $opt = $_post['field_view'];
    $nam = $_post['name'];

    $_lang = jrUser_load_lang_strings();
    $_save = array();

    // Update Lang Strings
    $_tm = jrCore_get_designer_form_fields($mod, $opt);
    $tbl = jrCore_db_table_name('jrUser', 'language');
    $lcd = jrCore_db_escape($_user['user_language']);
    if (isset($_tm[$nam]) && is_array($_tm[$nam])) {
        $_todo = array('label', 'sublabel', 'help');
        foreach ($_todo as $do) {
            $num = (isset($_tm[$nam][$do]) && jrCore_checktype($_tm[$nam][$do], 'number_nz')) ? (int) $_tm[$nam][$do] : 0;
            if (isset($num) && jrCore_checktype($num, 'number_nz')) {
                if (isset($_lang[$mod][$num])) {
                    if ($do === 'label') {
                        $_post[$do] = strtolower($_post[$do]);
                    }
                    $req = "UPDATE {$tbl} SET lang_text = '" . jrCore_db_escape($_post[$do]) . "' WHERE lang_module = '" . jrCore_db_escape($mod) . "' AND lang_key = '{$num}' AND (lang_code = '{$lcd}' OR lang_text LIKE '%change this%')";
                    jrCore_db_query($req);
                    $_save[$do] = $_post[$do];
                    $_post[$do] = $num;
                }
            }
        }
        jrCore_delete_all_cache_entries('jrUser');
    }

    // See if we are Create/Update Linked
    if (isset($_post['linked_form_field']) && $_post['linked_form_field'] == 'on') {
        $opp = ($_post['field_view'] == 'create') ? 'update' : 'create';
        $_tm = jrCore_get_designer_form_fields($mod, $opp);
        if (isset($_tm[$nam]) && is_array($_tm[$nam])) {
            $_todo = array('label', 'sublabel', 'help');
            foreach ($_todo as $do) {
                $num = (isset($_tm[$nam][$do]) && jrCore_checktype($_tm[$nam][$do], 'number_nz')) ? (int) $_tm[$nam][$do] : 0;
                if (isset($num) && jrCore_checktype($num, 'number_nz')) {
                    if (isset($_lang[$mod][$num])) {
                        $req = "UPDATE {$tbl} SET lang_text = '" . jrCore_db_escape($_save[$do]) . "' WHERE lang_module = '" . jrCore_db_escape($mod) . "' AND lang_key = '{$num}' AND (lang_code = '{$lcd}' OR lang_text LIKE '%change this%')";
                        jrCore_db_query($req);
                    }
                }
            }
        }
        jrCore_delete_all_cache_entries('jrUser');
    }

    // Check validation.  Some fields (such as checkbox) have specific validation
    // requirements - set this here so they cannot be set wrong.
    switch ($_post['type']) {
        case 'date':
        case 'datetime':
            $_post['validate'] = 'date';
            break;
        case 'select_date':
            $_post['validate'] = 'number_nz';
            break;
        case 'checkbox':
            $_post['validate'] = 'onoff';
            break;
        case 'select':
        case 'select_and_text':
        case 'select_multiple':
        case 'radio':
        case 'optionlist':
            // For a select field, our OPTIONS will come in either as a FUNCTION or as individual options on each line
            if (isset($_post['options']) && strlen($_post['options']) > 0) {
                $cfunc = $_post['options'];
                if (!function_exists($cfunc)) {
                    // okay - we're not a function
                    $_tmp = explode("\n", $_post['options']);
                    if (!is_array($_tmp)) {
                        jrCore_set_form_notice('error', 'You have entered an invalid value for Options - must be a valid function or a set of options, one per line.');
                        jrCore_form_result();
                    }
                    $_post['options'] = array();
                    foreach ($_tmp as $v) {
                        $v = trim($v);
                        if (strpos($v, '|')) {
                            list($k, $v) = explode('|', $v, 2);
                        }
                        else {
                            $k = $v;
                        }
                        $_post['options'][$k] = $v;
                    }
                    // Make sure the DEFAULT we get is a valid option
                    if (isset($_post['default']) && strlen($_post['default']) > 0 && !isset($_post['options']["{$_post['default']}"])) {
                        jrCore_set_form_notice('error', 'The value entered as the Default must be a valid value from the Options');
                        jrCore_form_field_hilight('default');
                        jrCore_form_result();
                    }
                }
            }
            else {
                jrCore_set_form_notice('error', 'You must enter valid Options for a Select form field');
                jrCore_form_result();
            }
            break;
    }

    // First - get existing default value for use below
    $def = '';
    $tbl = jrCore_db_table_name('jrCore', 'form');
    $req = "SELECT `default` FROM {$tbl} WHERE `module` = '" . jrCore_db_escape($_post['field_module']) . "' AND `name` = '" . jrCore_db_escape($_post['name']) . "' LIMIT 1";
    $_ev = jrCore_db_query($req, 'SINGLE');
    if ($_ev && is_array($_ev) && isset($_ev['default']) && strlen($_ev['default']) > 0) {
        $def = jrCore_db_escape($_ev['default']);
    }

    if (jrCore_verify_designer_form_field($_post['field_module'], $_post['field_view'], $_post, true)) {
        if (isset($_post['linked_form_field']) && $_post['linked_form_field'] == 'on') {
            // The linked lang strings are handled above - don't change them here
            unset($_post['label'], $_post['sublabel'], $_post['help']);
            $opp = ($_post['field_view'] == 'create') ? 'update' : 'create';
            if (!jrCore_verify_designer_form_field($_post['field_module'], $opp, $_post, true)) {
                jrCore_set_form_notice('error', "An error was encountered updating the linked form field in the {$opp} form view - please try again");
                jrCore_form_result();
            }
        }
        jrCore_form_delete_session();
        jrCore_form_delete_session_view($_post['field_module'], $_post['field_view']);
        jrCore_set_form_notice('success', 'The field settings were successfully updated');

        // Next, we need to update any existing values in the DB
        // with the new default value, but only for those that have not
        // been set, or are still set to the previous default value (if set)
        $val = (isset($_post['default'])) ? jrCore_db_escape($_post['default']) : '';
        jrCore_db_update_default_key($_post['field_module'], $_post['name'], $val, $def);
    }
    else {
        jrCore_set_form_notice('error', 'An error was encountered saving the form field - please try again');
    }
    jrCore_form_result("{$_conf['jrCore_base_url']}/{$_post['module_url']}/form_designer/m={$mod}/v={$opt}");
}
