<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
* @copyright 2021 Talldude Networks, LLC.
*/

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: form_field_update
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCore_form_field_update($_post, $_user, $_conf)
{
    global $_mods;
    jrUser_master_only();
    if (!isset($_post['m']) || !isset($_mods["{$_post['m']}"])) {
        jrCore_notice_page('error', 'invalid module');
    }
    if (!isset($_post['v']) || strlen($_post['v']) === 0) {
        jrCore_notice_page('error', 'invalid view');
    }
    if (!isset($_post['n']) || strlen($_post['n']) === 0) {
        jrCore_notice_page('error', 'invalid name');
    }
    $mod     = $_post['m'];
    $opt     = $_post['v'];
    $_fields = jrCore_get_designer_form_fields($mod, $opt);
    if (!$_fields || !is_array($_fields)) {
        jrCore_notice_page('error', 'This form has not been setup properly to work with the custom form designer (3)');
    }
    $nam = $_post['n'];
    if (!isset($_fields[$nam]) || !is_array($_fields[$nam])) {
        jrCore_notice_page('error', 'This form field has not been setup properly to work with the custom form designer');
    }
    $_fld = $_fields[$nam];

    $_lang = jrUser_load_lang_strings(null, false);

    jrCore_page_banner("field: <span style=\"text-transform:lowercase;\">{$_fld['name']}</span>", "{$_post['module_url']}/{$_post['v']}");

    // Some fields will BREAK if they are changed - warn about this
    $lock = false;
    switch ($nam) {
        case 'user_passwd1':
        case 'user_passwd2':
            jrCore_set_form_notice('warning', 'This field is required for proper functionality!<br>The <b>Type</b>, <b>Validation</b>, <b>Group</b> and <b>Active</b> fields have been disabled and cannot be changed.', false);
            $lock = true;
            break;
    }
    jrCore_get_form_notice();

    // Show our table of options
    $_tmp = array(
        'submit_value' => 'save changes',
        'cancel'       => 'referrer'
    );
    jrCore_form_create($_tmp);

    // Module
    $_tmp = array(
        'name'     => 'field_module',
        'type'     => 'hidden',
        'value'    => $mod,
        'validate' => 'core_string'
    );
    jrCore_form_field_create($_tmp);

    // View
    $_tmp = array(
        'name'     => 'field_view',
        'type'     => 'hidden',
        'value'    => $opt,
        'validate' => 'core_string'
    );
    jrCore_form_field_create($_tmp);

    // Name
    $_tmp = array(
        'name'     => 'name',
        'type'     => 'hidden',
        'value'    => $nam,
        'validate' => 'core_string'
    );
    jrCore_form_field_create($_tmp);

    // Fields can have the following attributes:
    // label
    // sublabel
    // help
    // name
    // type
    // validate
    // options
    // min
    // max
    // required

    // Field Label
    $_tmp = array(
        'name'     => 'label',
        'label'    => 'label',
        'help'     => 'This is the Label name that will appear to the left of the field.<br><br><strong>NOTE:</strong> If you see *change* in the field it means this text label has not been created yet - enter a label and save your changes.<br><br>Language ID: ' . $_fld['label'],
        'type'     => 'text',
        'value'    => (isset($_lang[$mod]["{$_fld['label']}"])) ? $_lang[$mod]["{$_fld['label']}"] : $_fld['label'],
        'validate' => 'printable'
    );
    jrCore_form_field_create($_tmp);

    // Bring in any custom form fields
    $_opt = array();
    $_fdo = array();
    $_tmp = jrCore_get_registered_module_features('jrCore', 'form_field');
    if ($_tmp && is_array($_tmp)) {
        foreach ($_tmp as $fmod => $_v) {
            foreach ($_v as $k => $v) {
                $_opt[$k] = $k;
                $fnc      = "{$fmod}_form_field_{$k}_form_designer_options";
                if (function_exists($fnc)) {
                    $_fdo[$k] = $fnc();
                }
            }
        }
        unset($_opt['custom']);
    }

    // Some field types have their own internal validation, so we "disable"
    // this field if those types are the selected one
    $_dsl = array();
    $_dfh = array();
    $_dis = array();
    $_dop = array();
    $_def = array();
    $_dmx = array();
    $_drq = array();
    foreach ($_fdo as $ft => $_fo) {
        if (isset($_fo['disable_sublabel']) && $_fo['disable_sublabel'] === true) {
            $_dsl[] = $ft;
        }
        if (isset($_fo['disable_help']) && $_fo['disable_help'] === true) {
            $_dfh[] = $ft;
        }
        if (isset($_fo['disable_validation']) && $_fo['disable_validation'] === true) {
            $_dis[] = $ft;
        }
        if (isset($_fo['disable_options']) && $_fo['disable_options'] === true) {
            $_dop[] = $ft;
        }
        if (isset($_fo['disable_default']) && $_fo['disable_default'] === true) {
            $_def[] = $ft;
        }
        if (isset($_fo['disable_min_and_max']) && $_fo['disable_min_and_max'] === true) {
            $_dmx[] = $ft;
        }
        if (isset($_fo['disable_required']) && $_fo['disable_required'] === true) {
            $_drq[] = $ft;
        }
    }

    // Field Sub Label
    $_tmp = array(
        'name'     => 'sublabel',
        'label'    => 'sub label',
        'sublabel' => 'optional',
        'help'     => 'This is the text that will be appear UNDER the Label in smaller type. Use this to let the user know about any restrictions in the field. This is an optional field - if left empty it will not show.<br><br>Language ID: ' . $_fld['sublabel'],
        'type'     => 'text',
        'value'    => (isset($_lang[$mod]["{$_fld['sublabel']}"])) ? $_lang[$mod]["{$_fld['sublabel']}"] : $_fld['sublabel'],
        'validate' => 'printable'
    );
    if (in_array($_fld['type'], $_dsl)) {
        $_js = array("$('.sublabel_element_right #sublabel').val('').attr('disabled','disabled')");
        jrCore_create_page_element('javascript_ready_function', $_js);
    }
    jrCore_form_field_create($_tmp);

    // Field Help
    $_tmp = array(
        'name'     => 'help',
        'label'    => 'help',
        'help'     => 'The Help text will appear in the small drop down area when the user clicks on the Question button (like you are viewing right now). Leave this empty to not show a help drop down.<br><br>Language ID: ' . $_fld['help'],
        'type'     => 'text',
        'value'    => (isset($_lang[$mod]["{$_fld['help']}"])) ? $_lang[$mod]["{$_fld['help']}"] : $_fld['help'],
        'validate' => false
    );
    if (in_array($_fld['type'], $_dfh)) {
        $_js = array("$('.help_element_right #help').val('').attr('disabled','disabled')");
        jrCore_create_page_element('javascript_ready_function', $_js);
    }
    jrCore_form_field_create($_tmp);

    // Field Type
    natcasesort($_opt);
    $_tmp = array(
        'name'     => 'type',
        'label'    => 'field type',
        'help'     => 'The Field Type defines the type of form element that will be displayed for this field.',
        'type'     => 'select',
        'options'  => $_opt,
        'value'    => $_fld['type'],
        'validate' => 'core_string',
        'onchange' => "var a=this.options[this.selectedIndex].value;var b={'" . implode("':1,'", $_dis) . "':1};if(typeof b[a] !== 'undefined' && b[a] == 1){\$('.validate_element_right select').attr('disabled','disabled').addClass('form_element_disabled')} else {\$('.validate_element_right select').removeAttr('disabled').removeClass('form_element_disabled')};var c={'" . implode("':1,'", $_dop) . "':1};if(typeof c[a] !== 'undefined' && c[a] == 1){\$('.options_element_right textarea').attr('disabled','disabled').addClass('form_element_disabled')} else {\$('.options_element_right textarea').removeAttr('disabled').removeClass('form_element_disabled')};var d={'" . implode("':1,'", $_def) . "':1};if(typeof d[a] !== 'undefined' && d[a] == 1){\$('.default_element_right #default').attr('disabled','disabled').addClass('form_element_disabled')} else {\$('.default_element_right #default').removeAttr('disabled').removeClass('form_element_disabled')};var e={'" . implode("':1,'", $_dmx) . "':1};if(typeof e[a] !== 'undefined' && e[a] == 1){\$('.min_element_right #min').attr('disabled','disabled').addClass('form_element_disabled');\$('.max_element_right #max').attr('disabled','disabled').addClass('form_element_disabled')} else {\$('.min_element_right #min').removeAttr('disabled').removeClass('form_element_disabled');\$('.max_element_right #max').removeAttr('disabled').removeClass('form_element_disabled')};var f={'" . implode("':1,'", $_drq) . "':1};if(typeof f[a] !== 'undefined' && f[a] == 1){\$('.required_element_right #required').attr('disabled','disabled').addClass('form_element_disabled')} else {\$('.required_element_right #required').removeAttr('disabled').removeClass('form_element_disabled')};var g={'" . implode("':1,'", $_dsl) . "':1};if(typeof f[a] !== 'undefined' && f[a] == 1){\$('.sublabel_element_right #sublabel').attr('disabled','disabled').addClass('form_element_disabled')} else {\$('.sublabel_element_right #sublabel').removeAttr('disabled').removeClass('form_element_disabled')};var h={'" . implode("':1,'", $_dsl) . "':1};if(typeof f[a] !== 'undefined' && f[a] == 1){\$('.help_element_right #help').attr('disabled','disabled').addClass('form_element_disabled')} else {\$('.help_element_right #help').removeAttr('disabled').removeClass('form_element_disabled')}"
    );
    foreach ($_fdo as $ft => $_fo) {
        if (!empty($_fo['type_help'])) {
            $_tmp['help'] .= "<br><br><strong>{$ft}</strong> - {$_fo['type_help']}";
        }
    }
    if ($lock) {
        $_tmp['disabled'] = 'disabled';
    }
    jrCore_form_field_create($_tmp);

    // Options
    $_opt = array();
    if (!empty($_fld['options']) && jrCore_checktype($_fld['options'], 'json')) {
        if ($_tmp = json_decode($_fld['options'], true)) {
            foreach ($_tmp as $k => $v) {
                $_opt[] = "{$k}|{$v}";
            }
            $_fld['options'] = implode("\n", $_opt);
        }
    }
    $_tmp = array(
        'name'     => 'options',
        'label'    => 'field options',
        'sublabel' => 'see <strong>help</strong> for what is allowed here',
        'help'     => 'The Options value will vary depending on the selected field type:',
        'type'     => 'textarea',
        'value'    => $_fld['options'],
        'validate' => 'allowed_html'
    );
    foreach ($_fdo as $ft => $_fo) {
        if (!empty($_fo['options_help'])) {
            $_tmp['help'] .= "<br><br><strong>{$ft}</strong> - {$_fo['options_help']}";
        }
    }
    if ($lock) {
        $_tmp['disabled'] = 'disabled';
    }
    if (in_array($_fld['type'], $_dop)) {
        $_js = array("$('.options_element_right #options').val('').attr('disabled','disabled')");
        jrCore_create_page_element('javascript_ready_function', $_js);
    }
    jrCore_form_field_create($_tmp);

    // Field Default
    $_tmp = array(
        'name'     => 'default',
        'label'    => 'default',
        'help'     => 'If you would like a default value to be used for this field, enter the default value here.',
        'type'     => 'text',
        'value'    => $_fld['default'],
        'validate' => 'printable'
    );
    if (isset($_fdo["{$_fld['type']}"]) && isset($_fdo["{$_fld['type']}"]['disable_default'])) {
        $_js = array("$('.default_element_right input').attr('disabled','disabled')");
        jrCore_create_page_element('javascript_ready_function', $_js);
    }
    jrCore_form_field_create($_tmp);

    // Validate
    $_opt = array();
    $_tmp = jrCore_get_registered_module_features('jrCore', 'checktype');
    if ($_tmp && is_array($_tmp)) {
        $_eng = jrUser_load_lang_strings('en-US');
        foreach ($_tmp as $mod => $_entries) {
            foreach ($_entries as $type => $ignore) {
                if ($type == 'array') {
                    continue;
                }
                $func = $mod . '_checktype_' . $type;
                if (function_exists($func)) {
                    $check_type = jrCore_checktype('', $type, false, true);
                    $check_desc = jrCore_checktype('', $type, true);
                    if (jrCore_checktype($check_desc, 'number_nz')) {
                        $check_desc = $_eng['jrCore'][$check_desc];
                    }
                    $_opt[$type] = '(' . $check_type . ') ' . $check_desc;
                }
            }
        }
    }
    natcasesort($_opt);
    $_tmp = array(
        'name'     => 'validate',
        'label'    => 'validation',
        'help'     => 'Select the type of field validation you would like to have for this field. The following field types:<br><br>optionlist<br>select<br>select_multiple<br>radio<br>image<br>file<br>audio<br>checkbox<br><br>are automatically validated internally, so the validation option will be grayed out if these field types are selected.',
        'type'     => 'select',
        'options'  => $_opt,
        'value'    => (isset($_fld['validate']) && strlen($_fld['validate']) > 0) ? $_fld['validate'] : 'not_empty',
        'validate' => 'core_string'
    );
    // See if we have selected a disabled type
    if (in_array($_fld['type'], $_dis)) {
        $_js = array("$('.validate_element_right select').attr('disabled','disabled')");
        jrCore_create_page_element('javascript_ready_function', $_js);
    }
    if ($lock) {
        $_tmp['disabled'] = 'disabled';
    }
    jrCore_form_field_create($_tmp);

    // Field Min
    $_tmp = array(
        'name'     => 'min',
        'label'    => 'minimum',
        'help'     => 'The Field Minimum Value will validate that any entered value is greater than or equal to the minimum value.<br><br><strong>For (number) Fields:</strong> This is the minimum value accepted.<br><strong>For (string) Fields:</strong> This is the minimum <strong>character length</strong> for the string.<br><strong>For (date) Fields:</strong> This is the minimum accepted date (in YYYYMMDD[HHMMSS] format).',
        'type'     => 'text',
        'value'    => (isset($_fld['min']) && $_fld['min'] == '0') ? '' : (int) $_fld['min'],
        'validate' => 'number_nn'
    );
    if (isset($_fdo["{$_fld['type']}"]) && isset($_fdo["{$_fld['type']}"]['disable_min_and_max'])) {
        $_js = array("$('.min_element_right input').attr('disabled','disabled')");
        jrCore_create_page_element('javascript_ready_function', $_js);
    }
    if ($lock) {
        $_tmp['disabled'] = 'disabled';
    }
    jrCore_form_field_create($_tmp);

    // Field Max
    $_tmp = array(
        'name'     => 'max',
        'label'    => 'maximum',
        'help'     => 'The Field Maximum Value will validate that any entered value is less than or equal to the maximum value.<br><br><strong>For (number) Fields:</strong> This is the maximum value accepted.<br><strong>For (string) Fields:</strong> This is the maximum <strong>character length</strong> for the string.<br><strong>For (date) Fields:</strong> This is the maximum accepted date (in YYYYMMDD[HHMMSS] format).',
        'type'     => 'text',
        'value'    => (isset($_fld['max']) && $_fld['max'] == '0') ? '' : (int) $_fld['max'],
        'validate' => 'number_nz'
    );
    if (isset($_fdo["{$_fld['type']}"]) && isset($_fdo["{$_fld['type']}"]['disable_min_and_max'])) {
        $_js = array("$('.max_element_right input').attr('disabled','disabled')");
        jrCore_create_page_element('javascript_ready_function', $_js);
    }
    if ($lock) {
        $_tmp['disabled'] = 'disabled';
    }
    jrCore_form_field_create($_tmp);

    // Field Group
    $_opt = array(
        'all'     => '(group) All Users (including logged out)',
        'user'    => '(group) All Users (logged in)',
        'master'  => '(group) Master Admins',
        'admin'   => '(group) Profile Admins',
        'power'   => '(group) Power Users (multiple profiles)',
        'visitor' => '(group) Logged Out Users'
    );
    $_qta = jrProfile_get_quotas();
    if (isset($_qta) && is_array($_qta)) {
        foreach ($_qta as $qid => $qname) {
            $_opt[$qid] = "(quota) {$qname}";
        }
    }
    $_tmp = array(
        'name'     => 'group',
        'label'    => 'display groups',
        'sublabel' => 'more than 1 group allowed',
        'help'     => 'If you would like this field to only be visible to Users in specific Profile Quotas, Profile Admins or Master Admins, select the group(s) here.',
        'type'     => 'select_multiple',
        'options'  => $_opt,
        'value'    => $_fld['group'],
        'default'  => 'user',
        'validate' => 'core_string'
    );
    if ($lock) {
        $_tmp['disabled'] = 'disabled';
    }
    jrCore_form_field_create($_tmp);

    // Field Required
    $_tmp = array(
        'name'     => 'required',
        'label'    => 'required',
        'help'     => 'If you would like to ensure a valid value is always received for this field, check the Field Required option.',
        'type'     => 'checkbox',
        'value'    => (isset($_fld['required']) && $_fld['required'] == '1') ? 'on' : 'off',
        'validate' => 'onoff'
    );
    if (isset($_fdo["{$_fld['type']}"]) && isset($_fdo["{$_fld['type']}"]['disable_required'])) {
        $_js = array("$('.required_element_right #required').attr('disabled','disabled')");
        jrCore_create_page_element('javascript_ready_function', $_js);
    }
    if ($lock) {
        $_tmp['disabled'] = 'disabled';
    }
    jrCore_form_field_create($_tmp);

    // Field Active
    $_tmp = array(
        'name'     => 'active',
        'label'    => 'active',
        'help'     => 'If Field Active is not checked, this field will not appear in the form.',
        'type'     => 'checkbox',
        'value'    => (isset($_fld['active']) && $_fld['active'] == '1') ? 'on' : 'off',
        'validate' => 'onoff'
    );
    if ($lock) {
        $_tmp['disabled'] = 'disabled';
    }
    jrCore_form_field_create($_tmp);

    if (isset($_post['v']) && ($_post['v'] == 'create' || $_post['v'] == 'update')) {

        // Make sure this module supplies the create/update view
        $opp = ($_post['v'] == 'create') ? 'update' : 'create';
        if (jrCore_load_view_function($mod, $opp)) {
            // Make sure it exists in the DB
            $_fields = jrCore_get_designer_form_fields($_post['m'], $opp);
            if (isset($_fields["{$_post['n']}"])) {
                // Link to Update/Create
                $_tmp = array(
                    'name'     => "linked_form_field",
                    'label'    => "change {$opp} field",
                    'help'     => "If you would like your changes to be saved to the same field in the &quot;{$opp}&quot; form, check here.",
                    'type'     => 'checkbox',
                    'value'    => 'on',
                    'validate' => 'onoff'
                );
                jrCore_form_field_create($_tmp);
            }
        }
    }

    jrCore_page_display();
}
