<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
* @copyright 2021 Talldude Networks, LLC.
*/

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: form_designer_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCore_form_designer_save($_post, $_user, $_conf)
{
    global $_mods;
    jrUser_master_only();
    jrCore_form_validate($_post);
    if (!isset($_post['field_module']) || !isset($_mods["{$_post['field_module']}"])) {
        jrCore_set_form_notice('error', 'Invalid module');
        jrCore_form_result();
    }
    if (!isset($_post['field_view']) || strlen($_post['field_view']) === 0) {
        jrCore_set_form_notice('error', 'Invalid view');
        jrCore_form_result();
    }
    if (isset($_post['new_name']) && $_post['new_name'] !== strtolower($_post['new_name'])) {
        jrCore_set_form_notice('error', 'New Field Name must be all lowercase');
        jrCore_form_result();
    }
    $mod     = $_post['field_module'];
    $opt     = $_post['field_view'];
    $_fields = jrCore_get_designer_form_fields($mod, $opt);
    if (!$_fields || !is_array($_fields)) {
        $_tmp = jrCore_get_registered_module_features('jrCore', 'designer_form');
        if (!isset($_tmp[$mod]) || !isset($_tmp[$mod][$opt])) {
            jrCore_set_form_notice('error', 'This form has not been setup properly to work with the custom form designer (2)');
            jrCore_form_result();
        }
    }
    $nam = trim(strtolower($_post['new_name']));
    // Make sure we don't already exist
    if (isset($_fields[$nam]) && is_array($_fields[$nam])) {
        jrCore_set_form_notice('error', 'The name you entered is already being used in this form - please enter a different name');
        jrCore_form_field_hilight('new_name');
        jrCore_form_result();
    }
    // See if our module has a DS prefix, or has registered a designer prefix
    $pfx = jrCore_db_get_prefix($mod);
    if (!$pfx) {
        // Check for registered prefix
        $_tmp = jrCore_get_registered_module_features('jrCore', 'designer_form_prefix');
        if (!isset($_tmp[$mod]) || !is_array($_tmp[$mod])) {
            jrCore_set_form_notice('error', 'This module is not setup with a DataStore prefix - unable to use form designer');
            jrCore_form_result();
        }
    }
    $prfx = jrCore_db_get_prefix($mod);
    if (strpos($_post['new_name'], "{$prfx}_") !== 0) {
        jrCore_set_form_notice('error', "The new field name must begin with &quot;{$prfx}_&quot;");
        jrCore_form_field_hilight('new_name');
        jrCore_form_result();
    }
    // We can't just use the prefix
    if ($_post['new_name'] == $prfx || $_post['new_name'] == "{$prfx}_") {
        jrCore_set_form_notice('error', "Please enter a valid field name beyond just the prefix");
        jrCore_form_field_hilight('new_name');
        jrCore_form_result();
    }

    // Validate the field does not already exist in our DS
    if (jrCore_db_item_key_exists($mod, $nam)) {

        // See if this is already being used in another form for this module
        $tbl = jrCore_db_table_name('jrCore', 'form');
        $req = "SELECT `view` FROM {$tbl} WHERE `module` = '" . jrCore_db_escape($mod) . "' AND `view` = '" . jrCore_db_escape($opt) . "' AND `name` = '" . jrCore_db_escape($nam) . "' LIMIT 1";
        $_ex = jrCore_db_query($req, 'SINGLE');
        if ($_ex && is_array($_ex)) {
            // This is a field we cannot create
            jrCore_set_form_notice('error', 'The name you entered is already being used in this form - please enter a different name (2)');
            jrCore_form_field_hilight('new_name');
            jrCore_form_result();
        }
    }

    // Looks good - create new form field
    $_field = array(
        'name'   => $_post['new_name'],
        'type'   => 'text',
        'label'  => $_post['new_name'],
        'locked' => '0'
    );
    jrCore_set_flag('jrcore_designer_create_custom_field', 1);
    $tmp = jrCore_verify_designer_form_field($mod, $opt, $_field);
    if ($tmp) {
        // See if we are also adding it to the create/update view
        if (isset($_post['linked_form_field']) && $_post['linked_form_field'] == 'on') {
            $opp = ($opt == 'create') ? 'update' : 'create';
            $tmp = jrCore_verify_designer_form_field($mod, $opp, $_field);
            if (!$tmp) {
                jrCore_set_form_notice('error', "An error was encountered inserting the new field into the {$opp} form - please try again");
                jrCore_form_result();
            }
        }
        $url = jrCore_get_module_url($mod);
        jrCore_form_delete_session();

        // Insert defaults into each existing record
        // This is required otherwise these records may not be searchable
        jrCore_db_create_default_key($_post['field_module'], $_post['new_name'], '');

        jrCore_form_result("{$_conf['jrCore_base_url']}/{$url}/form_field_update/m={$mod}/v={$opt}/n={$_post['new_name']}");
        return true;
    }
    jrCore_set_form_notice('error', 'An error was encountered saving the new for field to the database - please try again');
    jrCore_form_result();
    return true;
}
