<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: admin_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCore_admin_save($_post, $_user, $_conf)
{
    global $_conf, $_mods, $_urls;
    jrUser_master_only();
    if (isset($_post['module_delete']) && $_post['module_delete'] === 'on') {
        jrCore_validate_location_url();
    }
    else {
        jrCore_form_validate($_post);
    }

    // See what we are saving...
    switch ($_post['_1']) {

        case 'global':

            // See if this module is presenting us with a validate function
            if (is_file(APP_DIR . "/modules/{$_post['module']}/config.php")) {
                $vfunc = "{$_post['module']}_config_validate";
                if (!function_exists($vfunc)) {
                    require_once APP_DIR . "/modules/{$_post['module']}/config.php";
                }
                if (function_exists($vfunc)) {
                    $_temp = $vfunc($_post);
                    if (!$_temp) {
                        // Error in validation
                        jrCore_form_result();
                        return true;
                    }
                    $_post = $_temp;
                    unset($_temp);
                }
            }
            // Update
            foreach ($_post as $k => $v) {
                if (isset($_conf["{$_post['module']}_{$k}"])) {
                    jrCore_set_setting_value($_post['module'], $k, $v);
                }
            }

            jrCore_delete_config_cache();
            jrCore_trigger_event('jrCore', 'global_config_updated', $_post);
            jrCore_set_form_notice('success', 'The settings have been successfully saved');
            $ref = jrCore_get_local_referrer();
            if (strpos($ref, '/section=')) {
                $sec = '';
                $_tm = explode('/', $ref);
                if ($_tm && is_array($_tm)) {
                    foreach ($_tm as $part) {
                        if (strpos($part, 'section=') === 0) {
                            $sec = "/{$part}";
                        }
                    }
                }
                jrCore_form_delete_session();
                jrCore_form_result("{$_conf['jrCore_base_url']}/{$_post['module_url']}/admin/{$_post['_1']}{$sec}");
            }
            break;

        case 'quota':

            // See if this module is presenting us with a validate function
            if (is_file(APP_DIR . "/modules/{$_post['module']}/quota.php")) {
                $vfunc = "{$_post['module']}_quota_config_validate";
                if (!function_exists($vfunc)) {
                    require_once APP_DIR . "/modules/{$_post['module']}/quota.php";
                }
                if (function_exists($vfunc)) {
                    $_temp = $vfunc($_post);
                    if (!$_temp) {
                        // Error in validation
                        jrCore_form_result();
                        return true;
                    }
                    elseif (is_array($_temp)) {
                        $_post = $_temp;
                    }
                    unset($_temp);
                }
            }

            // See if we are doing a single quota or ALL quotas
            if (isset($_post['apply_to_all_quotas']) && $_post['apply_to_all_quotas'] == 'on') {
                $_aq = jrProfile_get_quotas();
                foreach ($_aq as $qid => $qname) {
                    $_qt = jrProfile_get_quota($_post['id'], false);
                    foreach ($_post as $k => $v) {
                        if (isset($_qt["quota_{$_post['module']}_{$k}"])) {
                            jrProfile_set_quota_value($_post['module'], $qid, $k, $v);
                        }
                    }
                }
            }
            else {
                if (!isset($_post['id']) || !jrCore_checktype($_post['id'], 'number_nz')) {
                    jrCore_set_form_notice('error', 'Invalid quota_id');
                    jrCore_form_result();
                }
                if (isset($_post['name']) && empty($_post['name'])) {
                    jrCore_set_form_notice('error', 'Invalid quota name - cannot be empty');
                    jrCore_form_field_hilight('name');
                    jrCore_form_result();
                }
                // Get current settings for this Quota
                $_qt = jrProfile_get_quota($_post['id'], false);
                if (!$_qt || !is_array($_qt)) {
                    jrCore_set_form_notice('error', 'Invalid quota_id - unable to retrieve settings');
                    jrCore_form_result();
                }
                // Update
                foreach ($_post as $k => $v) {
                    if (isset($_qt["quota_{$_post['module']}_{$k}"])) {
                        jrProfile_set_quota_value($_post['module'], $_post['id'], $k, $v);
                    }
                }
            }

            jrCore_form_delete_session();
            jrCore_set_form_notice('success', 'The settings have been successfully saved');
            jrCore_form_result("{$_conf['jrCore_base_url']}/{$_post['module_url']}/admin/{$_post['_1']}/id={$_post['id']}");
            break;

        case 'info':

            // Are we deleting this module?
            if (isset($_post['module_delete']) && $_post['module_delete'] === 'on') {

                $res = jrCore_delete_module($_post['module']);
                if ($res && strpos($res, 'error:') === 0) {
                    jrCore_set_form_notice('error', substr($res, 7));
                    jrCore_form_result("{$_conf['jrCore_base_url']}/{$_post['module_url']}/admin/info");
                }

                jrCore_logger('INF', "core: the " . $_mods["{$_post['module']}"]['module_name'] . " module was successfully deleted");
                jrCore_trigger_event('jrCore', 'module_deleted', $_post);
                jrCore_set_form_notice('success', 'The module was successfully deleted');
                jrCore_form_delete_session();

                jrCore_delete_all_cache_entries('jrCore');
                $_mods["{$_post['module']}"]['module_active'] = 0;
                jrCore_delete_registered_module_feature('jrCore', 'css', $_post['module']);
                jrCore_delete_registered_module_feature('jrCore', 'javascript', $_post['module']);

                // Rebuild JS and CSS
                jrCore_create_master_css($_conf['jrCore_active_skin']);
                jrCore_create_master_javascript($_conf['jrCore_active_skin']);

                jrCore_form_delete_session();
                jrCore_delete_config_cache();
                $url = jrCore_get_module_url('jrCore');
                jrCore_form_result("{$_conf['jrCore_base_url']}/{$url}/admin/global");

            }
            else {

                $tbl = jrCore_db_table_name('jrCore', 'module');
                $url = jrCore_db_escape($_post['module_url']);
                $mod = jrCore_db_escape($_post['module']);
                if (isset($_post['new_module_url']) && jrCore_checktype($_post['new_module_url'], 'url_name')) {

                    // Is this URL already being used by another module?
                    $nwu = jrCore_db_escape($_post['new_module_url']);
                    $req = "SELECT module_name FROM {$tbl} WHERE module_url = '{$nwu}' AND module_directory != '{$mod}' LIMIT 1";
                    $_ex = jrCore_db_query($req, 'SINGLE');
                    if ($_ex && is_array($_ex)) {
                        jrCore_set_form_notice('error', "The URL you entered is already being used by the {$_ex['module_name']} module");
                        jrCore_form_field_hilight('new_module_url');
                        jrCore_form_result("{$_conf['jrCore_base_url']}/{$_post['module_url']}/admin/info");
                    }
                    $url                 = jrCore_db_escape($_post['new_module_url']);
                    $_post['module_url'] = $_post['new_module_url'];

                }
                $cat = jrCore_db_escape($_post['new_module_category']);
                $act = (isset($_post['module_active']) && $_post['module_active'] == 'off') ? 0 : 1;

                // Update
                $req = "UPDATE {$tbl} SET module_updated = UNIX_TIMESTAMP(), module_url = '{$url}', module_active = {$act}, module_category = '{$cat}' WHERE module_directory = '{$mod}' LIMIT 1";
                $cnt = jrCore_db_query($req, 'COUNT');
                if ($cnt !== 1) {
                    jrCore_set_form_notice('error', 'An error was encountered saving the module settings - please try again');
                    jrCore_form_result("{$_conf['jrCore_base_url']}/{$_post['module_url']}/admin/info");
                }

                // @note leave this global here or $_conf is not changed after the jrCore_init_conf_mods_and_urls() call
                global $_conf;

                // If we are turning a module OFF let's give the module a chance to do any clean up if needed
                if ($act === 0 && isset($_mods[$mod]['module_active']) && intval($_mods[$mod]['module_active']) === 1) {

                    // @note: this event trigger must come BEFORE we reset anything!
                    jrCore_trigger_event('jrCore', 'module_deactivated', array('module' => $mod));

                    // We are ON and are turning OFF
                    // @note we have to delete the config cache separately from all cache items to properly support cache plugins
                    jrCore_delete_config_cache();
                    jrCore_load_config_file_and_defaults(true);

                    jrCore_init_conf_mods_and_urls();
                    $_rt = array(
                        '_conf' => $_conf,
                        '_mods' => $_mods,
                        '_urls' => $_urls
                    );
                    // @note: developer mode will be checked in jrCore_set_local_cache_key()
                    $exp = jrCore_get_config_value('jrCore', 'default_cache_seconds', 300);
                    jrCore_set_local_cache_key('config_cache', $_rt, $exp);

                    jrCore_delete_registered_module_feature('jrCore', 'css', $mod);
                    jrCore_delete_registered_module_feature('jrCore', 'javascript', $mod);
                    jrCore_create_master_css($_conf['jrCore_active_skin']);
                    jrCore_create_master_javascript($_conf['jrCore_active_skin']);

                }
                elseif ($act === 1 && (!isset($_mods[$mod]['module_active']) || intval($_mods[$mod]['module_active']) !== 1)) {

                    // @note: this event trigger must come BEFORE we reset anything!
                    jrCore_trigger_event('jrCore', 'module_activated', array('module' => $mod));

                    // We are OFF and are turning ON - ensure module is verified
                    define('IN_JAMROOM_INSTALLER', 1);  // This ensures init() is run
                    jrCore_verify_module($mod);

                    // @note we have to delete the config cache separately from all cache items to properly support cache plugins
                    jrCore_delete_config_cache();
                    jrCore_load_config_file_and_defaults(true);

                    jrCore_init_conf_mods_and_urls();
                    $_rt = array(
                        '_conf' => $_conf,
                        '_mods' => $_mods,
                        '_urls' => $_urls
                    );
                    // @note: developer mode will be checked in jrCore_set_local_cache_key()
                    $exp = jrCore_get_config_value('jrCore', 'default_cache_seconds', 300);
                    jrCore_set_local_cache_key('config_cache', $_rt, $exp);

                    // Rebuild JS and CSS
                    jrCore_create_master_css($_conf['jrCore_active_skin']);
                    jrCore_create_master_javascript($_conf['jrCore_active_skin']);

                }
                else {
                    // Reset caches for module
                    jrCore_delete_config_cache();
                    jrCore_load_config_file_and_defaults(true);

                    jrCore_init_conf_mods_and_urls();
                    $_rt = array(
                        '_conf' => $_conf,
                        '_mods' => $_mods,
                        '_urls' => $_urls
                    );
                    // @note: developer mode will be checked in jrCore_set_local_cache_key()
                    $exp = jrCore_get_config_value('jrCore', 'default_cache_seconds', 300);
                    jrCore_set_local_cache_key('config_cache', $_rt, $exp);

                    jrCore_create_master_css($_conf['jrCore_active_skin']);
                    jrCore_create_master_javascript($_conf['jrCore_active_skin']);
                }

                $_mods[$mod]['module_active'] = $act;
                if ($act === 1) {
                    jrCore_set_form_notice('success', 'The settings have been successfully saved'); // Module is currently disabled will show if its been deactivated.
                }

            }
            break;

        case 'language':

            // Get all the lang strings for this module
            $tbl = jrCore_db_table_name('jrUser', 'language');
            $mod = jrCore_db_escape($_post['module']);
            $req = "SELECT * FROM {$tbl} WHERE lang_module = '{$mod}' AND lang_code = '" . jrCore_db_escape($_post['lang_code']) . "'";
            $_rt = jrCore_db_query($req, 'lang_id');
            if (!isset($_rt) || !is_array($_rt)) {
                jrCore_set_form_notice('error', "Unable to retrieve language settings for module from language table - check debug_log errors");
                jrCore_form_result();
            }
            $req = "UPDATE {$tbl} SET lang_text = CASE lang_id\n";
            foreach ($_rt as $key => $_lng) {
                if (isset($_post["lang_{$key}"])) {
                    $req .= "WHEN {$key} THEN '" . jrCore_db_escape($_post["lang_{$key}"]) . "'\n";
                }
            }
            if (strpos($req, 'THEN')) {
                $req .= "ELSE lang_text END WHERE lang_id IN(" . implode(',', array_keys($_rt)) . ")";
                jrCore_db_query($req);
            }
            jrCore_delete_all_cache_entries('jrUser');
            jrCore_set_form_notice('success', 'The language strings have been successfully saved');
            jrCore_form_delete_session();
            jrCore_form_result("{$_conf['jrCore_base_url']}/{$_post['module_url']}/admin/{$_post['_1']}/lang_code={$_post['lang_code']}/p={$_post['p']}");
            break;

        case 'images':

            jrCore_create_media_directory(0, FORCE_LOCAL);
            // Get existing module info to see what images we have customized
            $_im = array();
            if (!empty($_conf["jrCore_{$_post['module']}_custom_images"])) {
                $_im = json_decode($_conf["jrCore_{$_post['module']}_custom_images"], true);
            }
            // Check for new custom files being uploaded
            $_up = jrCore_get_uploaded_meter_files($_post['upload_token']);
            if (is_array($_up)) {
                foreach ($_up as $_info) {
                    jrCore_write_media_file(0, "mod_{$_post['module']}_{$_info['name']}", $_info['tmp_name'], 'public-read');
                    $_im["{$_info['name']}"] = array($_info['size'], 'on');
                }
            }
            // Go through and save our uploaded images (if any)
            if (isset($_FILES) && is_array($_FILES)) {
                foreach ($_FILES as $k => $_info) {
                    $num = (int) str_replace('file_', '', $k);
                    if (isset($_info['size']) && jrCore_checktype($_info['size'], 'number_nz')) {
                        // Image extensions must match
                        $ext = jrCore_file_extension($_info['name']);
                        switch ($ext) {
                            case 'jpg':
                            case 'png':
                            case 'gif':
                                break;
                            default:
                                jrCore_set_form_notice('error', 'Invalid image type for ' . $_post["name_{$num}"] . ' - only JPG, PNG and GIF images are allowed');
                                jrCore_form_result();
                                break;
                        }
                        if (!empty($_post["name_{$num}"])) {
                            $nam = $_post["name_{$num}"];
                            jrCore_write_media_file(0, "mod_{$_post['module']}_{$nam}", $_info['tmp_name'], 'public-read');
                            jrCore_unlink($_info['tmp_name']);  // OK
                            $_im[$nam]                   = array($_info['size']);
                            $_post["name_{$num}_active"] = 'on';
                        }
                    }
                }
            }
            // Update setting with new values
            // [name_0_active] => on
            // [name_0] => bckgrd.png
            foreach ($_post as $k => $v) {
                if (strpos($k, 'name_') === 0 && strpos($k, '_active')) {
                    $num = (int) substr($k, 5, strrpos($k, '_'));
                    $nam = $_post["name_{$num}"];
                    if (isset($_im[$nam][0])) {
                        $_im[$nam][1] = $v;
                    }
                    else {
                        unset($_im[$nam]);
                    }
                }
            }
            if (count($_im) > 0) {
                jrCore_set_setting_value('jrCore', "{$_post['module']}_custom_images", json_encode($_im));
            }
            break;

        case 'templates':

            //  [form_begin_template_active] => on
            $_act = array();
            $_off = array();
            $_all = array();
            foreach ($_post as $k => $v) {
                if (strpos($k, '_template_active')) {
                    $tpl = str_replace('_template_active', '.tpl', $k);
                    // See if we are turning this template on or off
                    if ($v == 'on') {
                        $_act[] = $tpl;
                        $_all[] = $tpl;
                    }
                    else {
                        $_off[] = $tpl;
                        $_all[] = $tpl;
                    }
                }
            }

            // Set active/inactive
            if (isset($_all) && is_array($_all) && count($_all) > 0) {
                $mod = jrCore_db_escape($_post['module']);
                $tbl = jrCore_db_table_name('jrCore', 'template');
                if (isset($_act) && is_array($_act) && count($_act) > 0) {
                    $req = "UPDATE {$tbl} SET template_active = '1' WHERE template_module = '{$mod}' AND template_name IN('" . implode("','", $_act) . "')";
                    jrCore_db_query($req);
                }
                if (isset($_off) && is_array($_off) && count($_off) > 0) {
                    $req = "UPDATE {$tbl} SET template_active = '0' WHERE template_module = '{$mod}' AND template_name IN('" . implode("','", $_off) . "')";
                    jrCore_db_query($req);
                }

                // Reset cache for any that were changed
                foreach ($_all as $tpl) {
                    jrCore_get_template_file($tpl, $_post['module'], 'reset');
                }
            }
            jrCore_set_form_notice('success', 'The template settings have been successfully saved');
            break;
    }

    jrCore_form_delete_session();
    jrCore_form_result("{$_conf['jrCore_base_url']}/{$_post['module_url']}/admin/{$_post['_1']}");
    return true;
}
