<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: activity_log_download
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCore_activity_log_download($_post, $_user, $_conf)
{
    jrUser_master_only();
    // construct our query
    $add = '';
    $tbl = jrCore_db_table_name('jrCore', 'log');
    if (isset($_post['archive'])) {
        if (strlen($_post['archive']) === 6 && jrCore_checktype($_post['archive'], 'number_nz')) {
            $add = "_Archive_{$_post['archive']}";
            $tbl = jrCore_db_table_name('jrCore', 'log_' . $_post['archive']);
        }
        else {
            unset($_post['archive']);
        }
    }
    $req = "SELECT * FROM {$tbl} ORDER BY `log_id` ASC";
    $_rt = jrCore_db_query($req, 'NUMERIC');
    if (isset($_rt[0]) && is_array($_rt[0])) {
        $today = date("Ymd");
        $fn    = "Activity_Log{$add}_{$today}.csv";
        $data  = '"ID","Created","Priority","IP","Text"' . "\n";
        foreach ($_rt as $_x) {
            $_x['log_created'] = jrCore_format_time($_x['log_created']);
            $_x['log_text']    = trim(str_replace('"', '', $_x['log_text']));
            if (strpos($_x['log_text'], '%') === 0) {
                preg_match('/^%(\d*)%/', $_x['log_text'], $m);
                if (!empty($m[1])) {
                    $_x['log_text'] = substr($_x['log_text'], strpos($_x['log_text'], '%:') + 2);
                }
            }

            $data .= '"' . $_x['log_id'] . '","' . $_x['log_created'] . '","' . $_x['log_priority'] . '","' . $_x['log_ip'] . '","' . $_x['log_text'] . '"' . "\n";
        }
        jrCore_set_custom_header('Content-type: text/csv');
        jrCore_set_custom_header("Content-Disposition: attachment; filename=\"{$fn}\"");
        jrCore_send_response_and_detach($data);
    }
    jrCore_notice_page('error', 'No activity logs to download');
}
