<?php
/**
 * Country specific Phone Number formatter
 * @copyright 2003-2022 Talldude Networks, LLC.
 * @author Brian Johnson <brian [at] jamroom [dot] net>
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * Return the COUNTRY calling CODE for this country plugin
 * @return string
 */
function jrCore_plugin_format_phone_number_SG_country_code()
{
    return '+65-';
}

/**
 * Format a phone number specific for a country
 * @param string $string Phone Number to format
 * @return string
 */
function jrCore_plugin_format_phone_number_SG($string)
{
    // In Singapore, every phone number is written as +65-XXXX-YYYY or +65 XXXX YYYY.
    $_parts = array();
    $string = trim(str_replace('+', '', "{$string}"));
    // Country dialing code has been included
    if (strpos("{$string}", '65') === 0) {
        $string = trim(substr($string, 2));
    }
    // Format remainder
    $_parts[] = substr($string, 0, 4);
    $_parts[] = substr($string, 4, 4);
    return implode('-', $_parts);
}