<?php
/**
 * Country specific Phone Number formatter
 * @copyright 2003-2022 Talldude Networks, LLC.
 * @author Brian Johnson <brian [at] jamroom [dot] net>
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * Return the COUNTRY calling CODE for this country plugin
 * @return string
 */
function jrCore_plugin_format_phone_number_MY_country_code()
{
    return '+60 ';
}

/**
 * Format a phone number specific for a country
 * @param string $string Phone Number to format
 * @return string
 */
function jrCore_plugin_format_phone_number_MY($string)
{
    // Format as 000-000-0000
    $_parts = array();
    $string = trim(str_replace('+', '', "{$string}"));
    // Country dialing code has been included
    if (strpos("{$string}", '60') === 0) {
        $string = trim(substr($string, 2));
    }
    if (strpos("{$string}", '0') !== 0) {
        $string = "0{$string}";
    }
    // Format remainder
    $length = strlen("{$string}");
    if ($length === 10) {
        // 03-XXXX YYYY
        $_parts[] = substr($string, 0, 2);
        $_parts[] = '-' . substr($string, 2, 4);
        $_parts[] = ' ' . substr($string, 6, 4);
    }
    elseif ($length === 9) {
        // 088-XX YYYY
        $_parts[] = substr($string, 0, 3);
        $_parts[] = '-' . substr($string, 3, 2);
        $_parts[] = ' ' . substr($string, 5, 4);
    }
    else {
        $_parts[] = $string;
    }
    return implode('', $_parts);
}