<?php
/**
 * Country specific Phone Number formatter
 * @copyright 2003-2022 Talldude Networks, LLC.
 * @author Brian Johnson <brian [at] jamroom [dot] net>
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * Return the COUNTRY CODE for this country plugin
 * @return string
 */
function jrCore_plugin_format_phone_number_GB_country_code()
{
    return '(44) ';
}

/**
 * Format a phone number specific for a country
 * @see https://en.wikipedia.org/wiki/Telephone_numbers_in_the_United_Kingdom
 * @param string $string Phone Number to format
 * @return string
 */
function jrCore_plugin_format_phone_number_GB($string)
{
    if (strpos("{$string}", "44") === 0) {
        $string = substr($string, 2);
    }
    $_parts = array();
    $length = strlen($string);
    if ($length === 7) {
        // 000 0000
        $_parts[] = substr($string, 0, 3);
        $_parts[] = ' ' . substr($string, 3);
    }
    else {
        // 0000 0000
        $_parts[] = substr($string, 0, 4);
        $_parts[] = ' ' . substr($string, 4);
    }
    return implode('', $_parts);
}