// Jamroom Core Javascript - admin functions
// @copyright 2003-2017 by Talldude Networks LLC

var __jrcto = null;

/**
 * Set a page reload timeout on the Dashboard
 * @param {number} seconds
 * @param {number} auto
 * @param {function} f
 */
function jrCore_dashboard_reload_page(seconds, auto, f)
{
    var id = '#reload';
    var ck = jrReadCookie('reload');
    if (Number(auto) === 1 && typeof ck !== "undefined" && ck === 'off') {
        // We are disabled
        return true;
    }
    else if (typeof ck !== "undefined" && ck === 'on') {
        // See if we are reloading...
        if (Number(auto) !== 1) {
            return jrCore_dashboard_disable_reload(seconds);
        }
    }
    else {
        jrSetCookie('reload', 'on', 30);
    }

    $(id).removeClass('form_button_disabled');
    var d = 0;
    var v = seconds;
    __jrcto = setInterval(function() {
        d += 1;
        v -= 1;
        if (d >= seconds) {
            clearInterval(__jrcto);
            if (typeof f == "function") {
                return f();
            }
            else {
                window.location.reload();
            }
        }
        $(id).val(v);
    }, 1000);
}

/**
 * disable dashboard reload
 * @param {number} s seconds to reload
 * @returns {boolean}
 */
function jrCore_dashboard_disable_reload(s)
{
    jrSetCookie('reload', 'off');
    clearInterval(__jrcto);
    $('#reload').val(s).addClass('form_button_disabled');
    return true;
}

/**
 * Config the Dashboard with a custom panel
 * @param id
 * @returns {boolean}
 */
function jrCore_dashboard_panel(id)
{
    var u = core_system_url + '/' + jrCore_url + '/dashboard_panels/' + id + '/__ajax=1';
    $('#db_modal').modal();
    $.get(u, function(r) {
        $('#db_modal').html(r);
    });
    return false;
}

/**
 * Delete an Activity Log Entry
 * @param id
 * @returns {boolean}
 */
function jrCore_delete_activity_log(id)
{
    var f = $('.form_button');
    var u = core_system_url + '/' + jrCore_url + '/activity_log_delete/id=' + id + '/__ajax=1';
    jrCore_set_csrf_cookie(u);
    f.jrCore_disable_button();
    $.get(u, function(r) {
        if (r.msg === 'ok') {
            if (typeof id !== "number" && id.indexOf(',') !== -1) {
                // We have deleted multiple - reload
                window.location.reload();
            }
            else {
                $('#log-delete-' + id).parent().parent('tr').remove();
                f.jrCore_enable_button();
            }
        }
        else {
            jrCore_alert(r.msg)
            f.jrCore_enable_button();
        }
    });
}

/**
 * Delete an entry from the Queue Browser
 * @param id int
 * @returns {boolean}
 */
function jrCore_delete_queue_entry(id)
{
    var f = $('.form_button');
    var u = core_system_url + '/' + jrCore_url + '/queue_entry_delete/id=' + id + '/__ajax=1';
    jrCore_set_csrf_cookie(u);
    f.jrCore_disable_button();
    $.get(u, function() {
        if (id.indexOf(',') > -1) {
            window.location.reload();
        }
        else {
            $('#d' + id).parent().parent('tr').remove();
            if ($('.tk_checkbox').length === 0) {
                window.location.reload();
            }
            else {
                f.jrCore_enable_button();
            }
        }
    });
    return false;
}

/**
 * Set a panel in the dashboard
 * @param row int Row to set
 * @param col int Column to set
 * @param opt string Function to set
 */
function jrCore_set_dashboard_panel(row, col, opt)
{
    var u = core_system_url + '/' + jrCore_url + '/set_dashboard_panel/row=' + Number(row) + '/col=' + Number(col) + '/opt=' + jrE(opt) + '/__ajax=1';
    jrCore_set_csrf_cookie(u);
    $.post(u, function(r) {
        if (typeof r.error !== "undefined") {
            jrCore_alert(r.error);
        }
        else {
            $.modal.close();
            window.location.reload();
        }
    });
}

/**
 * Toggle full screen for a DOM ID
 * @param string id
 */
function jrCore_dashboard_fullscreen(id, cb)
{
    var e = document.getElementById(id);
    if (!document.mozFullScreen && !document.webkitFullScreen) {
        if (e.mozRequestFullScreen) {
            e.mozRequestFullScreen();
        }
        else {
            e.webkitRequestFullScreen(Element.ALLOW_KEYBOARD_INPUT);
        }
        var fs = setInterval(function() {
            jrCore_refresh_dashboard_panel_data();
        }, 60000);
        $('#' + id).addClass('page_table_fullscreen');
        $(document).on('webkitfullscreenchange mozfullscreenchange fullscreenchange', function(e) {
            if (!document.fullscreenElement) {
                $('#' + id).removeClass('page_table_fullscreen');
                clearInterval(fs);
            }
        });
    }
}

/**
 * Refresh the dashboard panel data
 */
function jrCore_refresh_dashboard_panel_data()
{
    var u = core_system_url + '/' + jrCore_url + '/get_dashboard_panel_data/__ajax=1';
    $.get(u, function(r) {
        if (typeof r.error !== "undefined") {
            jrCore_alert(r.error);
        }
        else {
            for (var d in r.data) {
                if (r.data.hasOwnProperty(d)) {
                    $(d).html(r.data[d]['title']);
                    if (typeof r.data[d]['class'] !== "undefined" && r.data[d]['class'] !== 'bigsystem-inf') {
                        $(d).addClass(r.data[d]['class']);
                    }
                    else {
                        // Make sure any are removed
                        var a = false;
                        if ($(d).hasClass('bigsystem-min')) {
                            a = 'bigsystem-min';
                        }
                        else if ($(d).hasClass('bigsystem-maj')) {
                            a = 'bigsystem-maj';
                        }
                        else if ($(d).hasClass('bigsystem-cri')) {
                            a = 'bigsystem-cri';
                        }
                        if (a) {
                            $(d).removeClass(a).addClass('bigsystem-inf');
                        }
                    }
                }
            }
        }
    });
}

/**
 * Get widget module info
 * @param i
 */
function jrCore_widget_list_get_module_info(i)
{
    var m = $(i).val();
    var a = $('#active_module');
    if (m !== a.val()) {
        a.val(m);
        var u = core_system_url + '/' + jrCore_url + '/widget_list_get_module_info/m=' + jrE(m) + '/__ajax=1';
        $.get(u, function(r) {
            $('#ff-row-list_custom_template').hide();
            $('#list_pagebreak').removeClass('form_element_disabled').removeAttr('disabled');
            $('#list_limit').removeClass('form_element_disabled').removeAttr('disabled');
            $('.list_search_op').removeClass('form_element_disabled').removeAttr('disabled');
            $('.list_search_text').removeClass('form_element_disabled').removeAttr('disabled');
            $('.list_search_key').each(function() {
                $(this).empty().removeClass('form_element_disabled').removeAttr('disabled');
                for (i = 0; i < r[0].length; ++i) {
                    $(this).append($('<option></option>').attr('value', r[0][i]).text(' ' + r[0][i]));
                }
            });
            $('#list_order_by_dir').removeClass('form_element_disabled').removeAttr('disabled');
            var id = $('#list_order_by_key');
            id.empty().removeClass('form_element_disabled').removeAttr('disabled');
            for (i = 0; i < r[0].length; ++i) {
                id.append($('<option></option>').attr('value', r[0][i]).text(' ' + r[0][i]));
            }
            id = $('#list_group_by');
            id.empty().removeClass('form_element_disabled').removeAttr('disabled');
            for (i = 0; i < r[0].length; ++i) {
                id.append($('<option></option>').attr('value', r[0][i]).text(' ' + r[0][i]));
            }
            id = $('#list_template');
            id.empty().removeClass('form_element_disabled').removeAttr('disabled');
            for (i in r[1]) {
                if (r[1].hasOwnProperty(i)) {
                    id.append($('<option></option>').attr('value', i).text(' ' + r[1][i]));
                }
            }
            jrCore_update_template_structure();
        });
    }
}

/**
 * Export CSV file
 * @param m module
 */
function jrCore_export_csv(m)
{
    $('#csv-dl').show(250, function() {
        setTimeout(function() {
            var u = core_system_url + '/' + jrCore_url + '/export_datastore_csv/m=' + m;
            jrCore_set_csrf_cookie(u);
            $.post(u, function(r) {
                $('#csv-dl').hide();
                if (typeof r.error !== 'undefined') {
                    jrCore_alert(r.error);
                }
                else {
                    jrCore_window_location(r.url);
                }
            });
        }, 250);
    });
    return false;
}

/**
 * Toggle optional field(s) in a form
 * @param {string} i DOM ID of checkbox
 * @param {string} e DOM ID of select
 */
function jrCore_toggle_config_option(i, e)
{
    var c = $(i);
    var r = $(e);
    if (r.is(':visible')) {
        c.prop('checked', true);
        r.hide();
    }
    else {
        c.prop('checked', false);
        r.show();
    }
}