<?php
 /**
 * Jamroom Banned Items module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: ban_item_delete_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrBanned_ban_item_delete_save($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_validate_location_url();

    if (!isset($_post['id']) || !jrCore_checktype($_post['id'], 'number_nz')) {
        jrCore_set_form_notice('error', 'Invalid ban item id');
        jrCore_form_result();
    }
    $bid = (int) $_post['id'];
    $tbl = jrCore_db_table_name('jrBanned', 'banned');
    $req = "SELECT ban_type FROM {$tbl} WHERE ban_id = {$bid}";
    $_rt = jrCore_db_query($req, 'SINGLE');
    if (!$_rt || !is_array($_rt)) {
        jrCore_set_form_notice('error', 'Invalid ban item id - not found');
        jrCore_form_result();
    }
    $req = "DELETE FROM {$tbl} WHERE ban_id = {$bid} LIMIT 1";
    $cnt = jrCore_db_query($req, 'COUNT');
    if ($cnt === 1) {

        // Reset caches
        $key = "jrbanned_config_{$_rt['ban_type']}";
        jrCore_delete_flag($key);
        jrCore_delete_local_cache_key($key);
        jrCore_delete_cache('jrBanned', $key, false, false);

        // Trigger our deletion
        jrCore_trigger_event('jrBanned', 'banned_item_delete', $_rt);

        jrCore_set_form_notice('success', 'The banned item was successfully deleted');
        jrCore_form_result();
    }
    jrCore_set_form_notice('error', 'An error was encountered deleting the banned item - please try again');
    jrCore_form_result();
}
