
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `iwp3452`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]additional_stats`
--

CREATE TABLE `[[dbprefix]]additional_stats` (
  `siteID` int(10) unsigned NOT NULL,
  `lastUpdatedTime` int(10) unsigned DEFAULT NULL,
  `stats` longtext COLLATE utf8mb4_unicode_ci,
  `type` enum('comments','users','itheme','malware','wordfence','brokenLink','posts','pages','links','defendwp') COLLATE utf8mb4_unicode_ci DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]addons`
--

CREATE TABLE `[[dbprefix]]addons` (
  `slug` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` enum('active','inactive') COLLATE utf8mb4_unicode_ci NOT NULL,
  `addon` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `validityExpires` int(10) unsigned DEFAULT NULL,
  `initialVersion` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `updateCurrentVersion` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `isFree` enum('0','1') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  UNIQUE KEY `slug` (`slug`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]addons_v3`
--

CREATE TABLE `[[dbprefix]]addons_v3` (
  `slug` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` enum('active','inactive') COLLATE utf8mb4_unicode_ci NOT NULL,
  `addon` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `validityExpires` int(10) unsigned DEFAULT NULL,
  `initialVersion` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `updateCurrentVersion` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `isFree` enum('0','1') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  UNIQUE KEY `slug` (`slug`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]allowed_login_ips`
--

CREATE TABLE `[[dbprefix]]allowed_login_ips` (
  `IP` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]changelog`
--

CREATE TABLE `[[dbprefix]]changelog` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` enum('plugins','themes','wp') COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `new_version` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `changelog` longtext COLLATE utf8mb4_unicode_ci,
  `last_updated` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fyi` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]favourites`
--

CREATE TABLE `[[dbprefix]]favourites` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` enum('plugins','themes') COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `URL` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `name_type_unique` (`type`,`name`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]favourites_groups_map`
--

CREATE TABLE `[[dbprefix]]favourites_groups_map` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `groupID` int(10) unsigned NOT NULL,
  `favouriteID` int(10) unsigned NOT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `groupID_favouriteID_unique` (`groupID`,`favouriteID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]favourite_groups`
--

CREATE TABLE `[[dbprefix]]favourite_groups` (
  `groupID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`groupID`),
  UNIQUE KEY `name_type_unique` (`name`(141),`type`(50))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]groups`
--

CREATE TABLE `[[dbprefix]]groups` (
  `groupID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`groupID`),
  UNIQUE KEY `name_UNIQUE` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]groups_sites`
--

CREATE TABLE `[[dbprefix]]groups_sites` (
  `groupID` int(10) unsigned DEFAULT NULL,
  `siteID` int(10) unsigned DEFAULT NULL,
  UNIQUE KEY `index1` (`groupID`,`siteID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]hide_list`
--

CREATE TABLE `[[dbprefix]]hide_list` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` enum('plugins','themes','core','translations') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `siteID` int(10) unsigned DEFAULT NULL,
  `name` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `URL` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]history`
--

CREATE TABLE `[[dbprefix]]history` (
  `historyID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `siteID` int(10) unsigned NOT NULL,
  `actionID` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `parentHistoryID` bigint(20) unsigned DEFAULT NULL,
  `type` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` enum('writingRequest','pending','initiated','running','completed','scheduled','netError','error','processingResponse','multiCallWaiting','retry') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `error` varchar(256) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `userID` int(10) unsigned NOT NULL,
  `URL` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `timeout` int(10) unsigned NOT NULL,
  `microtimeAdded` double(14,4) NOT NULL,
  `microtimeInitiated` double(14,4) DEFAULT NULL,
  `microtimeStarted` double(14,4) DEFAULT NULL,
  `microtimeEnded` double(14,4) DEFAULT NULL,
  `timeScheduled` int(10) unsigned DEFAULT NULL,
  `events` smallint(5) unsigned NOT NULL DEFAULT '1',
  `param1` text COLLATE utf8mb4_unicode_ci,
  `param2` text COLLATE utf8mb4_unicode_ci,
  `param3` text COLLATE utf8mb4_unicode_ci,
  `showUser` enum('Y','N') COLLATE utf8mb4_unicode_ci DEFAULT 'Y',
  `retried` smallint(6) DEFAULT '0',
  `runCondition` text COLLATE utf8mb4_unicode_ci,
  `callOpt` text COLLATE utf8mb4_unicode_ci,
  `isPluginResponse` enum('1','0') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `recheck` smallint(6) DEFAULT '0',
  `userIDCleared` int(10) unsigned DEFAULT NULL,
  `notifyFailed` enum('pending','checked','sent') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `connection_method` text COLLATE utf8mb4_unicode_ci,
  `isV3` enum('0','1') COLLATE utf8mb4_unicode_ci DEFAULT '0',
  PRIMARY KEY (`historyID`),
  KEY `actionID` (`actionID`),
  KEY `parentHistoryID` (`parentHistoryID`),
  KEY `microtimeInitiated` (`microtimeInitiated`),
  KEY `status` (`status`),
  KEY `type` (`type`),
  KEY `action` (`action`),
  KEY `notifyFailed` (`notifyFailed`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]history_additional_data`
--

CREATE TABLE `[[dbprefix]]history_additional_data` (
  `historyID` bigint(20) unsigned NOT NULL,
  `detailedAction` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `uniqueName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `resultID` int(10) unsigned DEFAULT NULL,
  `status` enum('pending','success','error','netError') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `error` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `errorMsg` text COLLATE utf8mb4_unicode_ci,
  `successMsg` text COLLATE utf8mb4_unicode_ci,
  UNIQUE KEY `historyID_uniqueName` (`historyID`,`uniqueName`(150)),
  KEY `historyID` (`historyID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]history_raw_details`
--

CREATE TABLE `[[dbprefix]]history_raw_details` (
  `historyID` bigint(20) unsigned NOT NULL,
  `request` longtext COLLATE utf8mb4_unicode_ci,
  `response` longtext COLLATE utf8mb4_unicode_ci,
  `callInfo` longtext COLLATE utf8mb4_unicode_ci,
  `panelRequest` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`historyID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]login_logs`
--

CREATE TABLE `[[dbprefix]]login_logs` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `userID` int(10) unsigned NOT NULL,
  `email` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `accessLevel` enum('admin','manager','others') COLLATE utf8mb4_unicode_ci DEFAULT 'others',
  `time` int(10) unsigned NOT NULL,
  `browserInfo` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `loginAuthType` enum('authNone','authBasic','authDuo') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `IP` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `error` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `loginAttemptStatus` enum('success','error') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `protocol` enum('HTTPS','HTTP') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `loginRedirect` enum('authNone','authBasic','authDuo') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `browser` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `time` (`time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]multisites`
--

CREATE TABLE `[[dbprefix]]multisites` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `parentSiteID` int(10) unsigned NOT NULL,
  `formatedURL` varchar(190) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `URL` varchar(190) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `URL` (`formatedURL`),
  KEY `parentSiteID` (`parentSiteID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]options`
--

CREATE TABLE `[[dbprefix]]options` (
  `optionID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `optionName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `optionValue` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`optionID`),
  UNIQUE KEY `optionName` (`optionName`(191))
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=26 ;

--
-- Dumping data for table `[[dbprefix]]options`
--

INSERT INTO `[[dbprefix]]options` VALUES
(1, 'installedTime', '[[timestamp]]'),
(2, 'anonymousDataNextSchedule', '[[timestamp_nextday]]'),
(3, 'serviceURL', 'https://service.infinitewp.com/'),
(4, 'anonymousDataLastSent', NULL),
(5, 'updateLastCheckV3', NULL),
(6, 'V3updateAvailable', NULL),
(7, 'updatesNotificationMailLastSent', NULL),
(8, 'cronLastRun', NULL),
(9, 'updateHideNotify', NULL),
(10, 'updateNotifySentToJSV3', NULL),
(11, 'updateNotificationDynamicContent', NULL),
(12, 'offlineNotifications', NULL),
(13, 'appRegisteredUserV3', NULL),
(14, 'updateAddonsAvailableV3', NULL),
(15, 'newAddonsAvailableV3', NULL),
(16, 'promoAddons', NULL),
(17, 'IWPSiteURL', 'https://infinitewp.com/'),
(18, 'supportURL', 'https://support.infinitewp.com/'),
(19, 'isDirectFSV3', 'Y'),
(20, 'pricingPlanTypes', 'a:3:{i:0;s:7:"starter";i:1;s:9:"developer";i:2;s:10:"freelancer";}'),
(21, 'lastCronNotRunAlert', '[[timestamp]]'),
(22, 'v3DirectInstall', '1'),
(23, 'connectionMethod', 'auto'),
(24, 'installedEmail', '[[admin_email]]'),
(25, 'lastRemoveInstallFolderNotified', '[[timestamp]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]popup_notification`
--

CREATE TABLE `[[dbprefix]]popup_notification` (
  `number` int(11) NOT NULL AUTO_INCREMENT,
  `ID` int(11) unsigned NOT NULL,
  `name` text COLLATE utf8mb4_unicode_ci,
  `status` enum('0','1') COLLATE utf8mb4_unicode_ci DEFAULT '0',
  `oneTimeOnly` enum('0','1') COLLATE utf8mb4_unicode_ci DEFAULT '0',
  `userTypes` enum('all','free','bundle','addon') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'all',
  `intervalTime` int(10) unsigned NOT NULL,
  `nextSchedule` int(10) unsigned NOT NULL,
  `breakTime` int(10) unsigned NOT NULL,
  `html` longtext COLLATE utf8mb4_unicode_ci,
  `isShowed` enum('0','1') COLLATE utf8mb4_unicode_ci DEFAULT '0',
  `version` enum('0','1','2') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  UNIQUE KEY `number` (`number`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]settings`
--

CREATE TABLE `[[dbprefix]]settings` (
  `general` text COLLATE utf8mb4_unicode_ci,
  `timeUpdated` int(10) unsigned DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]settings`
--

INSERT INTO `[[dbprefix]]settings` VALUES
('a:8:{s:31:"MAX_SIMULTANEOUS_REQUEST_PER_IP";s:1:"2";s:24:"MAX_SIMULTANEOUS_REQUEST";s:1:"3";s:33:"TIME_DELAY_BETWEEN_REQUEST_PER_IP";s:3:"200";s:13:"sendAnonymous";s:1:"0";s:24:"enableReloadDataPageLoad";s:1:"1";s:26:"autoSelectConnectionMethod";s:1:"1";s:32:"CONSIDER_3PART_IP_ON_SAME_SERVER";s:1:"1";s:8:"TIMEZONE";s:16:"America/New_York";}', 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]sites`
--

CREATE TABLE `[[dbprefix]]sites` (
  `siteID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `parentSiteID` int(10) unsigned NOT NULL,
  `URL` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `adminURL` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `IP` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `WPVersion` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pluginVersion` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `adminUsername` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `isOpenSSLActive` enum('1','0') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `randomSignature` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `privateKey` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `publicKey` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `activationKey` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `serverGroup` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `network` tinyint(3) unsigned DEFAULT NULL,
  `multisiteID` smallint(6) DEFAULT NULL,
  `parent` tinyint(3) unsigned DEFAULT NULL,
  `httpAuth` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `callOpt` text COLLATE utf8mb4_unicode_ci,
  `connectURL` enum('default','adminURL','siteURL') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'default',
  `connectionStatus` tinyint(1) NOT NULL DEFAULT '1',
  `links` text COLLATE utf8mb4_unicode_ci,
  `notes` text COLLATE utf8mb4_unicode_ci,
  `siteTechinicalInfo` text COLLATE utf8mb4_unicode_ci,
  `infoLastUpdate` datetime DEFAULT NULL,
  `siteCookie` text COLLATE utf8mb4_unicode_ci,
  `lastFaviconUpdate` int(10) unsigned NOT NULL DEFAULT '0',
  `favicon` text COLLATE utf8mb4_unicode_ci,
  `stagingBaseSiteID` int(10) unsigned DEFAULT NULL,
  `type` enum('normal','staging') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'normal',
  `stagingFtpDetails` text COLLATE utf8mb4_unicode_ci,
  `ftpDetails` text COLLATE utf8mb4_unicode_ci,
  `customBranding` text COLLATE utf8mb4_unicode_ci,
  `clientReportAutoDeleteLogLastUpdate` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`siteID`),
  UNIQUE KEY `siteURL_UNIQUE` (`URL`(191)),
  KEY `type` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]site_stats`
--

CREATE TABLE `[[dbprefix]]site_stats` (
  `siteID` int(10) unsigned NOT NULL,
  `lastUpdatedTime` int(10) unsigned DEFAULT NULL,
  `stats` longtext COLLATE utf8mb4_unicode_ci,
  `updatePluginCounts` int(10) unsigned DEFAULT '0',
  `updateThemeCounts` int(10) unsigned DEFAULT '0',
  `isTranslationUpdateAvailable` int(10) unsigned DEFAULT '0',
  `isCoreUpdateAvailable` enum('1','0') COLLATE utf8mb4_unicode_ci DEFAULT '0',
  `updateInfo` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`siteID`),
  KEY `siteID` (`siteID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]temp_storage`
--

CREATE TABLE `[[dbprefix]]temp_storage` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `paramID` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `time` int(10) unsigned NOT NULL,
  `data` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `type` (`type`,`paramID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]update_stats`
--

CREATE TABLE `[[dbprefix]]update_stats` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` enum('plugin','theme','core','translation') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `URL` text COLLATE utf8mb4_unicode_ci,
  `name` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `updatePresentCount` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `ID` (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]users`
--

CREATE TABLE `[[dbprefix]]users` (
  `userID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `password` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `accessLevel` enum('admin','manager') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `permissions` text COLLATE utf8mb4_unicode_ci,
  `status` enum('1','0') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `updatesNotificationMailLastSent` int(10) unsigned DEFAULT NULL,
  `recentlyLoggedIn` int(10) unsigned DEFAULT NULL,
  `notifications` text COLLATE utf8mb4_unicode_ci,
  `help` text COLLATE utf8mb4_unicode_ci,
  `authInfo` text COLLATE utf8mb4_unicode_ci,
  `resetPassword` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`userID`),
  UNIQUE KEY `email_UNIQUE` (`email`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]users`
--

INSERT INTO `[[dbprefix]]users` VALUES
(1, '[[admin_email]]', NULL, '[[admin_pass]]', 'admin', NULL, '1', NULL, NULL, 'a:1:{s:23:"updatesNotificationMail";a:5:{s:9:"frequency";s:6:"weekly";s:11:"coreUpdates";s:1:"1";s:13:"pluginUpdates";s:1:"1";s:12:"themeUpdates";s:1:"1";s:18:"translationUpdates";s:1:"1";}}', NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user_access`
--

CREATE TABLE `[[dbprefix]]user_access` (
  `userID` int(10) unsigned DEFAULT NULL,
  `siteID` int(10) unsigned DEFAULT NULL,
  UNIQUE KEY `index1` (`userID`,`siteID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
