<?php
require_once('includes/app.php');

if (defined('ALLOW_DIFFERENT_ORGIN')) { // This for development only
    header("Access-Control-Allow-Origin: http://localhost:8080");
    header("Access-Control-Allow-Credentials: true");
}
/**
 * Handle file uploads via XMLHttpRequest
 */
class qqUploadedFileXhr {
    /**
     * Save the file to the specified path
     * @return boolean TRUE on success
     */
    function save($path) {    
        $input = fopen("php://input", "r");
        $tmpFileFallBack = false;
        if (!function_exists('tmpfile')) {
            $tmpFileFallBack = true;
            $temp = fopen('php://temp', 'r+');
        }else{
            $temp = tmpfile();
        }
        $realSize = stream_copy_to_stream($input, $temp);
        fclose($input);
        
        if ($realSize != $this->getSize()){            
            return false;
        }
        
        $target = fopen($path, "w");        
        fseek($temp, 0, SEEK_SET);
        stream_copy_to_stream($temp, $target);
        fclose($target);
        if ($tmpFileFallBack) {
            fclose($temp); 
        }
        return true;
    }
    function getName() {
        return $_GET['qqfile'];
    }
    function getSize() {
        if (isset($_SERVER["CONTENT_LENGTH"])){
            return (int)$_SERVER["CONTENT_LENGTH"];            
        } else {
            throw new Exception('Getting content length is not supported.');
        }      
    }   
}

/**
 * Handle file uploads via regular form post (uses the $_FILES array)
 */
class qqUploadedFileForm {  
    /**
     * Save the file to the specified path
     * @return boolean TRUE on success
     */
    function save($path) {
        if(!empty($_FILES['qqfile']['tmp_name']) && !move_uploaded_file($_FILES['qqfile']['tmp_name'], $path)){
            return false;
        }elseif (!move_uploaded_file($_FILES['file']['tmp_name'], $path)) {
            return false;
        }
        return true;
    }
    function getName() {
        if (!empty($_FILES['qqfile']['name'])) {
            return $_FILES['qqfile']['name'];
        }
        return $_FILES['file']['name'];
    }
    function getSize() {
         if (!empty($_FILES['qqfile']['size'])) {
            return $_FILES['qqfile']['size'];
        }
        return $_FILES['file']['size'];
    }
}

class qqFileUploader {
    private $allowedExtensions = array();
    private $sizeLimit = 20971520;
    private $file;

    function __construct(array $allowedExtensions = array(), $sizeLimit = 20971520){        

        $allowedExtensions = array_map("strtolower", $allowedExtensions);
        $this->allowedExtensions = $allowedExtensions;        
        $this->sizeLimit = $sizeLimit;
        $this->checkServerSettings(); 
      
        if (isset($_GET['qqfile'])) {
            $this->file = new qqUploadedFileXhr();
        } elseif (isset($_FILES['qqfile'])) {
            $this->file = new qqUploadedFileForm();
        }elseif (isset($_FILES['file']['name'])) {
            $this->file = new qqUploadedFileForm();
        } else {
            $this->file = false; 
        }
    }
    
    private function checkServerSettings(){ 
        if (version_compare(phpversion(), '5.3.0') < 0 && function_exists('ini_set')) {
            @ini_set('post_max_size', (($this->sizeLimit/1024)/1024).'M');
            @ini_set('upload_max_filesize', (($this->sizeLimit/1024)/1024).'M');
        } else {
            $postSize = $this->toBytes(ini_get('post_max_size'));
            $uploadSize = $this->toBytes(ini_get('upload_max_filesize'));
            $this->sizeLimit = ($postSize < $uploadSize ) ? $postSize :$uploadSize;
        }
    }
    
    private function toBytes($str){
        $val = trim($str);
        $last = strtolower($str[strlen($str)-1]);
        switch($last) {
            case 'g': $val *= 1024;
            case 'm': $val *= 1024;
            case 'k': $val *= 1024;        
        }
        return $val;
    }
    
    /**
     * Returns array('success'=>true) or array('error'=>'error message')
     */
    function handleUpload($uploadDirectory, $replaceOldFile = FALSE){
		    $pathinfo = pathinfo($this->file->getName());
        $filename = $pathinfo['filename'];
        //$filename = md5(uniqid());
        $ext = $pathinfo['extension'];
		
		
        if(isset($_GET['imageOnly'])){
			$this->allowedExtensions = array('png', 'jpg', 'gif');
        }elseif(isset($_GET['allWPFiles'])){
            $this->allowedExtensions = array('png', 'jpg', 'gif','php','js','html','htm','css','xml','csv','zip','pdf','doc','docx','txt','mp3','mo','po');
        }else{
			$this->allowedExtensions = array('zip');
		}
        if(isset($_GET['uploadFavouriteThemesAndPlugins'])){
            $uploadDirectory = APP_ROOT.'/uploads/favorites/';
            $favoritesUpload = 1;
        }

        if($this->allowedExtensions && !in_array(strtolower($ext), $this->allowedExtensions)){
           // $these = implode(', ', $this->allowedExtensions);
		   
            if(isset($_GET['imageOnly'])){
				$these = 'jpg, png, gif';
            }elseif(isset($_GET['allWPFiles'])){
                $these = 'png, jpg, gif, php, js, html, htm, css, xml, csv, zip, pdf, doc, docx, txt, mp3, mo, po';
			}else{
				$these = 'zip';
			}
            return array('error' => 'Upload only "'.$these.'" files. Please try again.');
        }
        
        if (!is_writable($uploadDirectory)){
            if ($favoritesUpload == 1) {
                if (!file_exists($uploadDirectory)) {
                    if(!@mkdir($uploadDirectory, 0755, true)){
                        return array('error' => "Cannot create folder to save favorites. Please change the folder permission for the [ IWP Admin Panel]/uploads folder to 755 or 777.");
                    }
                } else {
                    return array('error' => "Favorites directory isn't writable. Please change the folder permission for the [IWP Admin Panel]/uploads/favorites folder to 755 or 777.");
                }
            } else {
                return array('error' => "Upload directory isn't writable. Please change the folder permission for the [IWP Admin Panel]/uploads folder to 755 or 777.");
            }
        }
        
        if (!$this->file){
            return array('error' => 'No files were uploaded.');
        }
        
        $size = $this->file->getSize();
        
        if ($size == 0) {
            return array('error' => 'File is empty');
        }
        
        if ($size > $this->sizeLimit) {
            return array('error' => 'File is too large');
        }
        
    
        if(!$replaceOldFile){
           if(isset($_GET['allWPFiles']) && file_exists($uploadDirectory . $filename . '.' . $ext.'.swp') ){
                $filename .= rand(10, 99);
            }else{
            /// don't overwrite previous files that were uploaded
            while (file_exists($uploadDirectory . $filename . '.' . $ext)) {
                $filename .= rand(10, 99);
            	}
        	}
        }
        
        if(isset($_GET['allWPFiles']) && $this->file->save($uploadDirectory . $filename . '.' . $ext.'.swp')){
            return array('success'=>true,'filename'=>$filename.'.'.$ext.'.swp');
        }elseif ($this->file->save($uploadDirectory . $filename . '.' . $ext)){
            return array('success'=>true,'filename'=>$filename.'.'.$ext,'reportType'=>(isset($_GET['reportType']) && $_GET['reportType'])?$_GET['reportType']:'');
        } else {
            return array('error'=> 'Could not save uploaded file.' .
                'The upload was cancelled, or server error encountered');
        }
        
    }

    function copy($source, $target){
        if (!copy($source, $target)) {
            return false;
        }
        return true;
    }
}
// list of valid extensions, ex. array("jpeg", "xml", "bmp")
/*?>

<?php*/
$allowedExtensions = array("zip","jpg","png", "gif");
// max file size in bytes
$sizeLimit = 20 * 1024 * 1024;

$uploader = new qqFileUploader($allowedExtensions, $sizeLimit);
$result = $uploader->handleUpload('uploads/');
if ($result['success'] && (isset($_GET['reportType']) && $_GET['reportType']) && file_exists(APP_ROOT_V2.'/uploads/')) {
    $report = $uploader->copy(APP_ROOT.'/uploads/'.$result['filename'], APP_ROOT_V2.'/uploads/'.$result['filename']);
    if (!$report) {
       return array('Unable to upload in v2 upload directory check APP_ROOT_V2 constant in config.php file'); 
    }

}

// to pass data through iframe you will need to encode all html tags
echo htmlspecialchars(jsonEncoder($result), ENT_NOQUOTES);
