<?php
/************************************************************
 * InfiniteWP Admin panel									*
 * Copyright (c) 2012 Revmakx								*
 * www.revmakx.com											*
 *															*
 ************************************************************/

$isLoginPage = true; 
define('USER_SESSION_NOT_REQUIRED', true);
include("includes/app.php");
//This function is used to identify the error msg to display the user
function getLoginPageMsg($key) {
	$errorMsg = array();
	$errorMsg['invalid'] 			= 'Invalid credentials.';
	$errorMsg['access'] 			= 'Access restricted.';
	$errorMsg['reactive'] 			= 'You are deactivated by admin.';
	$errorMsg['onlyAdmin'] 			= 'Only admin can log in.';
	$errorMsg['passcodeValidity'] 	= 'Your Passcode has been expired.';
	$errorMsg['passcodeInvalid']	= 'Invalid passcode.';
	$errorMsg['passcodeMailError'] 			= 'Mail send error on two factor authentication.';
	$errorMsg['accountLock'] 		= 'You account has been locked. Please wait %s to regain access to your panel. ';
	$errorMsg['resetPasswordLinkExpired'] 		= 'Reset link expired. Reinitiate the password reset.';
	$errorMsg['resetPasswordLinkInvalid'] 		= 'Reset link expire or invalid. Reinitiate the password reset.';
	$errorMsg['resetPasswordLinkExceedAttempt'] = 'Your password reset link is no longer valid. Request a new password reset link';
	$errorMsg['resetPasswordMailError'] 		= 'Unable to send email. Check email settings.';
	$errorMsg['resetPasswordEmailNotFound'] 	= 'Oops. We weren\'t able to find that email.<br>Please make sure this is email that you used before.';
	$errorMsg['resetPasswordFailed'] 	= 'Error while resetting the password.Try again!';
	$errorMsg['resetPasswordInvalidPassword']	= 'Please enter valid password.';//NEED BETTER CONTENT    
	setHook('errorMsgTemplate', $errorMsg);

	$successMsg = array();    
	$successMsg['logout'] 				= 'You have successfully logged out.';
	$successMsg['passcodeMailSent']		= 'We have sent you an email.<br>Check your email now.';
	$successMsg['resetPasswordChanged'] = 'Password reset successfully.<br> You can login now with your new password.';    
	$successMsg['resetPasswordMailSent']= 'We have sent you a password reset link.<br>Check your email now.';  

	
	setHook('successMsgTemplate', $successMsg);

    if(isset($errorMsg[$key])){
    	return $errorMsg[$key];
    }
    elseif(isset($successMsg[$key])){
    	return $successMsg[$key];
    }
    return '';
}

function printLoginPageMsg(){
	$successMsg = $errorMsg = '';
	if(!empty($_GET['errorMsg'])) {
		$errorMsg = getLoginPageMsg($_GET['errorMsg']);
		$errorMsg = formateMsg($errorMsg);
		echo '<div class="errorMsg"><img src="images/error.svg" class="successMsgImage" /><div class="successMsgText">'.$errorMsg.'</div></div>';
	} elseif(!empty($_GET['successMsg'])) {
		$successMsg = getLoginPageMsg($_GET['successMsg']);
		$successMsg = formateMsg($successMsg);
		echo '<div class="successMsg"><img src="images/success.svg" class="successMsgImage"><div class="successMsgText">'.$successMsg.'</div></div>';

	}
}

function formateMsg($msgStr) {
	if(!empty($_GET['lockOut'])) {
		$lockOutString = base64_decode($_GET['lockOut']) - time();
		if($lockOutString<0) {
			header('Location: '.APP_URL.'loginsample.php');
			exit;
		}
		return sprintf($msgStr, convertToMinSec($lockOutString));
	}
	return $msgStr;
}

//controllers start here
if(isset($_POST['sig_response'])){
	if(function_exists('verifyDuoSign')){
		if(!verifyDuoSign($_POST)) {
			$_GET['errorMsg'] = "duoFailed";
		}
	}
}elseif(isset($_GET['state']) && isset($_GET['duo_code'])){
    if(function_exists('verifyDuoSignV4')){
        if(!verifyDuoSignV4($_GET)) {
            $_GET['errorMsg'] = "duoFailed";
        }
    }
}elseif(!empty($_GET['passlink'])){
	verifyPasscode($_GET['passlink'], 'link');
}elseif(!empty($_POST['passcode'])){
	verifyPasscode($_POST);
}elseif(!empty($_REQUEST['email']) && !empty($_REQUEST['password'])){
    userLogin($_REQUEST);
}
elseif(!empty($_GET['logout'])){
	userLogout(true);
}
elseif(!empty($_POST['action']) && ($_POST['action'] == 'resetPasswordSendMail' || $_POST['action'] == 'resetPasswordChange')){
	userLoginResetPassword($_POST);
}
elseif(!empty($_GET['view']) && $_GET['view'] == 'resetPasswordChange'){
	userLoginResetPassword($_GET);
}
//controllers ends here

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	<meta name="robots" content="noindex">
	<title>InfiniteWP</title>
	<link href='https://fonts.googleapis.com/css?family=Lato:normal,bold' rel='stylesheet' type='text/css'>
	<link rel="stylesheet" type="text/css" href="css/login.css" />
	<script src="js/jquery.min.js?<?php echo APP_VERSION; ?>" type="text/javascript" charset="utf-8"></script>
	<script>
	$(document).ready(function(){
		$(".showPass").live('mousedown',function(){			
			var btn=document.getElementById('newPasswordOrg');
	  		btn.setAttribute('type', 'text');
	  		$(this).text("Hide");  		
		}).live('mouseup',function(){			
			var btn=document.getElementById('newPasswordOrg');
	  		btn.setAttribute('type', 'password');
			$(this).text("Show");			
		});

	});

	</script>

</head>
<body>
	<div class="top-nav">
		<div id="logo">
			<img src="images/iwp_panel_logo.png" style="height: 26px;"><div id="version">Admin Panel <?php echo APP_VERSION; ?></div>
		</div>
	</div>
	<div class="login_cont">
		<form action="login.php" method="post" >
			<?php
				if($_GET['view'] == 'resetPassword'){//show email form for resetting password
					showResetPasswordForm();
				} elseif($_GET['view'] == 'resetPasswordChange'){//show new password form for resetting via email link
					showResetPasswordChangeForm();
				}elseif($_GET['view'] == 'getPasscode'){//Get the passcode from user from mail
					showGetPasscodeForm();
				}elseif($_GET['view'] == 'duoFrame'){
					showDuoFrame();
				} else{//show login form
					showLoginForm();
				}

				function showLoginForm(){
					printLoginPageMsg(); ?>
					<div class="login-form">
						<div class="login_header">
							<div class="login_header_text">
								Login to manage your WP sites
							</div>
						</div>
						<div class="input-control">
							<input type="text" class="input-field-design" value="" name="email" autofocus placeholder="Email">
						</div>
						<div class="input-control">
							<input type="password" value="" class="input-field-design" name="password" placeholder="Password">
						</div>
						<div class="login">
							<input type="submit" class="submit-button" value="Login">
						</div>
						<div class="login"></div>
					</div>
					<div class="signup-forgot">
						<a href="login.php?view=resetPassword">Forgot Password?</a>
					</div>
				<?php }
				function showGetPasscodeForm(){
					printLoginPageMsg();
					?>
					<div class="login-form">
						<div class="login_header">
							<div class="login_header_text">
								Login to manage your WP sites
							</div>
						</div>
						<div class="input-control">
							<input type="text" value="" class="input-field-design" autofocus name="passcode" placeholder="Passcode">
							<input type="hidden" name="auth" value="passcode" />
						</div>
						<div class="login">
							<input type="submit" class="submit-button" value="Login">
						</div>
						<div class="login"></div>
					</div>
				<?php } 
				function showDuoFrame(){
					printLoginPageMsg();
					echo $GLOBALS['duoFrameStr']; ?>
				<?php }
				function showResetPasswordForm(){
					printLoginPageMsg();
					?>
					<div class="login-form">
						<div class="login_header">
							<div class="login_header_text">
								Forgot Password
							</div>
						</div>
						<div class="input-control">
							<input type="email" class="input-field-design" autofocus name="email" placeholder="Email">
							<input type="hidden" name="action" value="resetPasswordSendMail" />
						</div>
						<div class="login">
							<input type="submit" class="submit-button" value="Send Reset Link">
						</div>
						<div class="login"></div>
					</div>

				<?php }
				function showResetPasswordChangeForm(){
					printLoginPageMsg();
					?>
					<div class="login-form">
						<div class="login_header">
							<div class="login_header_text">
								Create a new password below
							</div>
						</div>
						<div class="input-control">
							<input type="password" autofocus class="input-field-design" id="newPasswordOrg" name="newPassword" placeholder="New password">
							<img src="images/eye.svg" class="showPass">
							<input type="hidden" name="transID" value="<?php echo $_GET['transID']; ?>" />
							<input type="hidden" name="resetHash" value="<?php echo $_GET['resetHash']; ?>" />
							<input type="hidden" name="action" value="resetPasswordChange" />
						</div>
						<div class="login">
							<input type="submit" class="submit-button" value="Reset Password">
						</div>
						<div class="login"></div>
					</div>
				<?php }
				?>
			</form>
		</div>
	</body>
	</html>


