<?php

class addonInstallAndUpdate extends panelRequestManager{

	public static function getAddonsDownloadURL($addons){
		// $addons['installClone']['downloadLink'] = "http://localhost:8081/#/page/addons";
		// $addons['installClone']['error'] = 1;
		// $addons['installClone']['errorMsg'] = 'Error while downloading addon';
		// return $addons;
		$installedHash = getInstalledHash();
		$currentGeneralSettings = Reg::get('settings');
		foreach($addons as $key => $addon){
			$tokenParam = '&downloadToken='.$addon['token'];
			if ($addon['token'] === 'free') {
				$tokenParam = '&isFree=1';
			}
			// appUpdateMsg('Checking download for '.$addon['slug'].'...');
			$downloadCheckLink = getOption('serviceURL').'downloadV3.php?appInstallHash='.APP_INSTALL_HASH.'&installedHash='.$installedHash.'&appVersion='.APP_VERSION.'&type=addon&downloadType=install&download='.$addon['slug'].'&downloadVersion='.$addon['version'].$tokenParam;		
			if($currentGeneralSettings['participateBeta'] == 1){
				$downloadCheckLink .= '&participateBeta=1';
			}
					
			$temp = doCall($downloadCheckLink, '', $timeout=30);
			list($result, , , $curlInfo) = $temp;
			
			//$result = base64_decode($result);
			//$result = @unserialize($result);
			$result = getServiceResponseToArray($result);
			
			$cURLErrors = new cURLErrors($curlInfo);
			if($cURLErrors->isOk()){
				if($result['status'] == 'success'){
					$addons[$key]['downloadLink'] = $result['downloadLink'];//$downloadCheckLink.'&checked=true';
					$uniqid = self::saveTempAddons($key,$addons);
					$addons[$key]['uniqid'] = $uniqid;

				}
				elseif($result['status'] == 'error'){
					$addons[$key]['error'] = 1;
					$addons[$key]['errorMsg'] = 'Error while downloading addon '.$addon['slug'].': '.$result['errorMsg'];
					// unset($addons[$key]);
					// appUpdateMsg('Error while downloading addon '.$addon['slug'].': '.$result['errorMsg']);
				}
			}else{
				$addons[$key]['error'] = 1;
				$addons[$key]['errorMsg'] = 'Error while downloading addon '.$addon['slug'].': Unable to communicate with server(' . $cURLErrors->getErrorMsg() .').';
				// unset($addons[$key]);
				// appUpdateMsg('Error while downloading addon '.$addon['slug'].': Unable to communicate with server(' . $cURLErrors->getErrorMsg() .').');
			}	
		}

		return $addons;
	}

	public static function downloadAddons($addons){
		foreach($addons as $key => $addon){
			if(!empty($addon)){
				if(!empty($addon['uniqid'])){
					$downloadLink = self::getTempDownloadLink($key,$addon['uniqid']);
				}elseif (!empty($addon['downloadLink'])){
					$downloadLink = $addon['downloadLink'];
				}else{
					$addons[$key]['error'] = 1;
					$addons[$key]['errorMsg'] = $addon['slug'].' addon download link not found.';
					continue;
				}
				if(!empty($downloadLink)){
					//$fileMD5 = $updateDetails['fileMD5'];
				
					$zip = getTempName('addon_'.$addon['slug'].'.zip');
					
					// appUpdateMsg('Downloading '.$addon['slug'].' package...');
					$isDone = downloadURL($downloadLink, $zip);			
					
					if(!$isDone){ //download failed
						$addons[$key]['error'] = 1;
						$addons[$key]['errorMsg'] = $addon['slug'].' package download failed.';
						// appUpdateMsg($addon['slug'].' package download failed.', true);
						continue;
					}else{
						$addons[$key]['zip'] = $zip;
						$uniqid = self::saveTempAddons($key,$addons);
						$addons[$key]['uniqid'] = $uniqid;
						unset($addons[$key]['zip']);
					}		
				}
					
			}
		}
		return $addons;
	}

	public static function getTempDownloadLink($slug,$uniqid){
		$where = array(
	  		'query' =>  "type = ':type' AND paramID = ':paramID'",
	  		'params' => array(
	  		   ':type'=>$slug,
	  		   ':paramID'=>$uniqid
				)
		);
		$getDatas = DB::getField("?:temp_storage", "data", $where);
		DB::delete("?:temp_storage", $where);
		if(!empty($getDatas)){
			$updateInfo = unserialize($getDatas);
			return $updateInfo[$slug]['downloadLink'];
		}
	}

	public static function getTempUnzip($slug,$uniqid){
		$where = array(
	  		'query' =>  "type = ':type' AND paramID = ':paramID'",
	  		'params' => array(
	  		   ':type'=>$slug,
	  		   ':paramID'=>$uniqid
				)
		);
		$getDatas = DB::getField("?:temp_storage", "data", $where);
		DB::delete("?:temp_storage", $where);
		if(!empty($getDatas)){
			$updateInfo = unserialize($getDatas);
			return $updateInfo[$slug]['zip'];
		}
	}

	public static function saveTempAddons($key,$addons){
		$uniqid = uniqid('', true);
		$data = DB::insert("?:temp_storage", array('type' => $key, 'paramID' =>$uniqid , 'time' => time(), 'data' =>  serialize($addons)));
		if($data){
			return $uniqid;
		}else{
			return false;
		}

	}

	public static function unZipAddons($addons){
		foreach($addons as $key => $addon){
			if(!empty($addon['zip']) || !empty($addon['uniqid'])){
				$zip = $addon['zip'];
				if(!empty($addon['uniqid']) && empty($addon['zip'])){
					$zip = self::getTempUnzip($key,$addon['uniqid']);
				}elseif (!empty($addon['zip'])){
					$zip = $addon['zip'];
				}else{
					$addons[$key]['error'] = 1;
					$addons[$key]['errorMsg'] = $addon['slug'].' addon download link not found.';
					continue;
				}
				if(!initFileSystem()){
					$addons[$key]['error'] = 1;
					$addons[$key]['errorMsg'] = 'Unable to initiate file system.';
					// appUpdateMsg('Unable to initiate file system.', true);
					return $addons;
				}
				
				$unPackResult = unPackToWorkingDir($zip);
				if(!empty($unPackResult) && is_array($unPackResult)){
					$source = $unPackResult['source'];
					$remoteSource = $unPackResult['remoteSource'];
				}
				else{
					$addons[$key]['error'] = 1;
					if (!empty($GLOBALS['updateMsg'])) {
						$addons[$key]['errorMsg'] = $GLOBALS['updateMsg'];
					}else{
						$addons[$key]['errorMsg'] = 'Unable to Extract the package.';
					}
					return $addons;
				}
				
				$destination = APP_ROOT;
				if(!copyToRequiredDir($source, $remoteSource, $destination)){
					$addons[$key]['error'] = 1;
					if (!empty($GLOBALS['updateMsg'])) {
						$addons[$key]['errorMsg'] = $GLOBALS['updateMsg'];
					}else{
						$addons[$key]['errorMsg'] = 'Unable to Extract the package.';
					}
				}
				

				// appUpdateMsg('Unzipped '.$addon['slug'].' package.');
				$addons[$key]['process']['unzipDone'] = true;

				@unlink($zip);
			}
		}
		return $addons;
	}

	public static function installAddons($addons){
		foreach($addons as $key => $addon){
			if(empty($addon['process']['unzipDone'])){
				continue;	
			}
			$ok=false;
			// appUpdateMsg('Installing '.$addon['slug'].' addon...');
			$where = array(
				      		'query' =>  "slug = ':slug'",
				      		'params' => array(
				               ':slug'=>$addon['slug']
	           				)
	        			);
			$isExist = DB::getField("?:addons_v3", "slug", $where);
			if($isExist){
				$addons[$key]['error'] = 1;
				$addons[$key]['errorMsg'] = 'The '.$addon['slug'].' addon is already installed.';
				// /appUpdateMsg('The '.$addon['slug'].' addon is already installed.');
				return $addons;
			}		

			$free = '0';
			if($addon['token'] == 'free'){
				$free = '1';
			}
			
			if(file_exists(APP_ROOT.'/addons/'.$addon['slug'].'/addon.'.$addon['slug'].'.php')){
				//activating the addon
				$isDone = DB::insert("?:addons_v3", array('slug' => $addon['slug'], 'addon' => $addon['addon'], 'status' => 'active', 'validityExpires' => $addon['validityExpires'], 'initialVersion' => $addon['version'], 'updateCurrentVersion' => $addon['version'], 'isFree' => $free));
				if($isDone){
					$ok=true;
					include_once(APP_ROOT.'/addons/'.$addon['slug'].'/addon.'.$addon['slug'].'.php');
					if(method_exists('addon'.ucfirst($addon['slug']), 'install')){

						$isSuccess = call_user_func(array('addon'.ucfirst($addon['slug']),'install'));
						if(!$isSuccess){
							$ok=false;
							$where = array(
					          'query' => "slug = ':slug'",
					          'params' => array(
					               ':slug'=>$addon['slug']
					           )
					        );
							DB::delete("?:addons_v3", $where);
							// appUpdateMsg('An error occurred while installing the '.$addon['slug'].' addon.');
							$addons[$key]['error'] = 1;
							$addons[$key]['errorMsg'] = 'An error occurred while installing the '.$addon['slug'].' addon.';
							return $addons;
						}
					}
					if($ok){
						$addons[$key]['installed'] = 1;
						// appUpdateMsg($addon['slug'].' addon successfully installed.');
						
						//remove addon install available for this addon so that it will stop false notification in next browser app load
						$newAddonsAvailableTemp = @unserialize(getOption('newAddonsAvailableV3'));
						if(isset($newAddonsAvailableTemp[ $addon['slug'] ])){
							$newAddonsAvailableTemp[ $addon['slug'] ]['isInstalled'] = true;
							updateOption('newAddonsAvailableV3', serialize($newAddonsAvailableTemp));
						}//commented because new installed getting deleted in next run
					}
				}
			}
			else{
				$addons[$key]['error'] = 1;
				$addons[$key]['errorMsg'] = 'A file was found missing while installing the '.$addon['slug'].' addon.';
				return $addons;
				// appUpdateMsg('A file was found missing while installing the '.$addon['slug'].' addon.');
			}
						
			$optionVer['action'] = 'installed';
			$optionVer['actionTime'] = time();
			$optionVer['prevVer'] = '0';
			$optionVer['newVer'] = $addon['version'];
			$optionVer['slug'] = $addon['slug'];
			manipulateOption('versionLogsV3', $optionVer);
		}
		// updateOption('updateLastCheckV3', 0);
		return $addons;
	}
	public static function getUpdateAddonsDownloadURL($addons){
		$installedHash = getInstalledHash();
		$currentGeneralSettings = Reg::get('settings');
		foreach($addons as $key => $addon){
			$freeParam = '';
			if ($addon['isFree'] === '1') {
				$freeParam = '&isFree=1';
			}
			// appUpdateMsg('Checking download for '.$addon['slug'].'...');
			$downloadCheckLink = getOption('serviceURL').'downloadV3.php?appInstallHash='.APP_INSTALL_HASH.'&installedHash='.$installedHash.'&appVersion='.APP_VERSION.'&type=addon&downloadType=update&download='.$addon['slug'].'&downloadVersion='.$addon['updateAvailable']['version'].$freeParam;
			if($currentGeneralSettings['participateBeta'] == 1){
				$downloadCheckLink .= '&participateBeta=1';
			}
					
			$temp = doCall($downloadCheckLink, '', $timeout=30);
			list($result, , , $curlInfo) = $temp;
			
			//$result = base64_decode($result);
			//$result = @unserialize($result);
			$result = getServiceResponseToArray($result);
			
			$cURLErrors = new cURLErrors($curlInfo);
			if($cURLErrors->isOk()){
				if($result['status'] == 'success'){
					$addons[$key]['downloadLink'] = $result['downloadLink'];//$downloadCheckLink.'&checked=true';
					$uniqid = self::saveTempAddons($key,$addons);
					$addons[$key]['uniqid'] = $uniqid;
				}
				elseif($result['status'] == 'error'){
					$addons[$key]['error'] = 1;
					$addons[$key]['errorMsg'] = 'Error while downloading addon '.$addon['slug'].': '.$result['errorMsg'];
					// unset($addons[$key]);
					// appUpdateMsg('Error while downloading addon '.$addon['slug'].': '.$result['errorMsg']);
				}
			}else{
				$addons[$key]['error'] = 1;
				$addons[$key]['errorMsg'] = 'Error while downloading addon '.$addon['slug'].': Unable to communicate with server(' . $cURLErrors->getErrorMsg() .').';
				// unset($addons[$key]);
				// appUpdateMsg('Error while downloading addon '.$addon['slug'].': Unable to communicate with server(' . $cURLErrors->getErrorMsg() .').');
			}	
		}

		return $addons;
	}
	public static function updateAddons($addons){
		foreach($addons as $key => $addon){
			if($addon['process']['unzipDone']){			
				//$addon['process']['updated'] = true;
				if(!initFileSystem()){
					$addons[$key]['error'] = 1;
					$addons[$key]['errorMsg'] = 'Unable to initiate file system.';
					// appUpdateMsg('Unable to initiate file system.', true);
					return $addons;
				}
				include_once(APP_ROOT.'/addons/'.$addon['slug'].'/addon.'.$addon['slug'].'.php');
				$where = array(
				      		'query' =>  "slug = ':slug'",
				      		'params' => array(
				               ':slug'=>$addon['slug']
	           				)
	        			);
				$prevVer = DB::getField("?:addons_v3", "updateCurrentVersion", $where);

				if(method_exists('addon'.ucfirst($addon['slug']),'update')){
					call_user_func(array('addon'.ucfirst($addon['slug']),'update'));
				}
				$newAddonVersion = getAddonVersion($addon['slug']);
				
				$optionVer['action'] = 'updated';
				$optionVer['actionTime'] = time();
				$optionVer['prevVer'] = $prevVer;
				$optionVer['newVer'] = $newAddonVersion;
				$optionVer['slug'] = $addon['slug'];
				manipulateOption('versionLogsV3', $optionVer);
				
				DB::update("?:addons_v3", array('updateCurrentVersion' => $newAddonVersion), $where);//updating in database that addon is updated
				
				//remove updateAvailable for this addon so that it will stop false update notification in next browser app load
				$updateAddonsAvailable = @unserialize(getOption('updateAddonsAvailableV3'));
				if(isset($updateAddonsAvailable[ $addon['slug'] ]['updateAvailable']) && !empty($updateAddonsAvailable[ $addon['slug'] ]['updateAvailable'])){
					$updateAddonsAvailable[ $addon['slug'] ]['updateAvailable']['isInstalled'] = true;
					updateOption('updateAddonsAvailableV3', serialize($updateAddonsAvailable));
				}
				$addons[$key]['installed'] = 1;
				// appUpdateMsg('Addon '.$addon['slug'].' successfully updated.');		
			}
		}
		return $addons;

	}

}

panelRequestManager::addClassToPanelRequest('addonInstallAndUpdate');