"""
This program is free software: you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License,
or (at your option) any later version.


This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
See the GNU General Public License for more details.


You should have received a copy of the GNU General Public License
 along with this program.  If not, see <https://www.gnu.org/licenses/>.

Copyright © 2019 Cloud Linux Software Inc.

This software is also available under ImunifyAV commercial license,
see <https://www.imunify360.com/legal/eula>
"""
import subprocess
import urllib.request
from pathlib import Path
from logging import getLogger

from defence360agent.contracts.license import LicenseCLN
from defence360agent.subsys.panels.cpanel import cPanel
from defence360agent.subsys.panels.hosting_panel import HostingPanel
from imav.contracts.config import MalwareTune


logger = getLogger(__name__)
SOURCE_URL = "https://repo.imunify360.cloudlinux.com/defence360/i360deploy.sh"
TARGET_PATH = Path("/var/imunify360/tmp/i360deploy.sh")


async def deploy_im360():
    """
    Deploys imunify360 for CPanel installations.
    """
    if MalwareTune.NO_AUTO_UPGRADE:
        logger.warning(
            "No upgrade flag file exists. Skipping imunify360 upgrade"
        )
        return True

    hp = HostingPanel()
    license_token = LicenseCLN.get_token()
    if license_token.get("status") != "ok" or hp.NAME != cPanel.NAME:
        return False

    try:
        if not TARGET_PATH.exists():
            TARGET_PATH.parent.mkdir(parents=True, exist_ok=True)
            with urllib.request.urlopen(SOURCE_URL, timeout=10) as response:
                content = response.read()
                TARGET_PATH.write_bytes(content)
        TARGET_PATH.chmod(0o700)

        # Execute the downloaded file
        subprocess.Popen(
            ["/usr/libexec/report-command-error", TARGET_PATH, "IPL", "-y"],
            start_new_session=True,
        )
    except Exception as e:
        logger.error("Failed to upgrade to imunify360: %r", e)
        return False
    return True
