<?php
/**
 * @property \modelBilling $model
 */
class actionBillingOutsCancel extends cmsAction {

    public function run($id = false) {

        if (!$id) {
            return cmsCore::error404();
        }

        if (!cmsForm::validateCSRFToken($this->request->get('csrf_token', ''))) {
            return cmsCore::error404();
        }

        $this->model->startTransaction();

        $out = $this->model->forUpdate()->getOut($id);

        if (!$out || $out['status'] == modelBilling::OUT_STATUS_CANCELED) {
            return cmsCore::error404();
        }

        $success = $this->model->cancelOut($out);

        $this->model->endTransaction($success);

        cmsUser::addSessionMessage(LANG_BILLING_OUT_CANCEL, 'success');

        return $this->redirectToAction('outs');
    }

}
