"""
This program is free software: you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License,
or (at your option) any later version.


This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
See the GNU General Public License for more details.


You should have received a copy of the GNU General Public License
 along with this program.  If not, see <https://www.gnu.org/licenses/>.

Copyright © 2019 Cloud Linux Software Inc.

This software is also available under ImunifyAV commercial license,
see <https://www.imunify360.com/legal/eula>
"""
from logging import getLogger
from typing import Dict

from defence360agent.contracts.messages import MessageType
from defence360agent.contracts.plugins import (
    MessageSink,
    MessageSource,
    expect,
)
from defence360agent.utils import Scope

logger = getLogger(__name__)


class PostAction(MessageSink, MessageSource):
    PROCESSING_ORDER = MessageSink.ProcessingOrder.POST_ACTION
    SCOPE = Scope.IM360

    async def create_sink(self, loop):
        pass

    async def create_source(self, loop, sink):
        self._sink = sink

    @expect(MessageType.MalwareCleanup)
    async def process_post_action(self, message: Dict):
        post_action = message.pop("post_action", None)
        if not post_action:
            return

        # We have only `MalwareActionIm360.detect` as a post action right now.
        # It takes hits from DB so we don't need to do anything with them here
        await post_action(scan_id=message["scan_id"], sink=self._sink)
