"""
This program is free software: you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License,
or (at your option) any later version.


This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
See the GNU General Public License for more details.


You should have received a copy of the GNU General Public License
 along with this program.  If not, see <https://www.gnu.org/licenses/>.

Copyright © 2019 Cloud Linux Software Inc.

This software is also available under ImunifyAV commercial license,
see <https://www.imunify360.com/legal/eula>
"""
from logging import getLogger

from defence360agent.contracts.config import ConfigFile
from defence360agent.contracts.config import Malware as Config
from defence360agent.contracts.plugins import MessageSource
from defence360agent.utils import recurring_check, Scope
from imav.malwarelib.subsys import cxs

logger = getLogger(__name__)


class InotifyScan(MessageSource):
    SCOPE = Scope.IM360

    def __init__(self):
        self._enable_task = None

    async def create_source(self, loop, sink):
        self._loop = loop
        self._sink = sink

        self._enable_task = self._loop.create_task(self._check_enable())

    async def shutdown(self):
        if self._enable_task is not None:
            self._enable_task.cancel()
            await self._enable_task

    @recurring_check(Config.CONFIG_CHECK_PERIOD)
    async def _check_enable(self):
        if cxs.cxswatch_running() and Config.INOTIFY_ENABLED:
            ConfigFile().set("MALWARE_SCANNING", "enable_scan_inotify", False)
