"""
This program is free software: you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License,
or (at your option) any later version.


This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
See the GNU General Public License for more details.


You should have received a copy of the GNU General Public License
 along with this program.  If not, see <https://www.gnu.org/licenses/>.

Copyright © 2019 Cloud Linux Software Inc.

This software is also available under ImunifyAV commercial license,
see <https://www.imunify360.com/legal/eula>
"""
import ipaddress
import socket

CLIENT_PORTAL_IP = "139.162.216.201"


def get_current_ip():
    s = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
    s.settimeout(10)
    try:
        s.connect((CLIENT_PORTAL_IP, 1))
        return s.getsockname()[0]
    finally:
        s.close()


def is_private_ip(ipv4: str) -> bool:
    ip = ipaddress.ip_address(ipv4)
    networks = ["10.0.0.0/8", "172.16.0.0/12", "192.168.0.0/16"]  # rfc1918
    return any(ip in ipaddress.ip_network(net) for net in networks)


def is_ipv4(ip: str) -> bool:
    try:
        ipaddress.IPv4Address(ip)
    except ipaddress.AddressValueError:
        return False
    return True
