"""
This program is free software: you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License,
or (at your option) any later version.


This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
See the GNU General Public License for more details.


You should have received a copy of the GNU General Public License
 along with this program.  If not, see <https://www.gnu.org/licenses/>.

Copyright © 2019 Cloud Linux Software Inc.

This software is also available under ImunifyAV commercial license,
see <https://www.imunify360.com/legal/eula>
"""
import logging
from defence360agent.contracts.messages import MessageType
from imav.model.wordpress import WPSite

logger = logging.getLogger(__name__)


async def send_event(sink, event: str, site: WPSite, version: str = None):
    if version is None:
        version = "1.0.0"

    await sink.process_message(
        MessageType.WordpressPluginTelemetry(
            event=event,
            domain=site.domain,
            site_path=site.docroot,
            user=site.uid,
            plugin_version=version,
        )
    )
