"""
This program is free software: you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License,
or (at your option) any later version.


This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
See the GNU General Public License for more details.


You should have received a copy of the GNU General Public License
 along with this program.  If not, see <https://www.gnu.org/licenses/>.

Copyright © 2019 Cloud Linux Software Inc.

This software is also available under ImunifyAV commercial license,
see <https://www.imunify360.com/legal/eula>
"""
from pathlib import Path

from defence360agent.application import tags
from defence360agent.application.settings import configure as base_configure
from defence360agent.rpc_tools.utils import (
    get_schema_paths as base_get_schema_paths,
)
from defence360agent.rpc_tools.validate import (
    SchemaValidator,
    validate_middleware,
)
from imav.malwarelib import model as malwarelib_model
from imav.simple_rpc.schema import init_validator


def get_schema_paths(full=False):
    path = Path(__file__).parent.parent.absolute()
    schema_paths = (
        path / "malwarelib" / "rpc",
        path / "patchman" / "rpc",
        path / "simple_rpc",
    )
    if full:
        schema_paths += (path / "malwarelib" / "advanced" / "rpc",)
    return schema_paths


def configure(
    init_validator=init_validator,
    validator_cls=SchemaValidator,
    validate_middleware_wrap=validate_middleware,
    models_modules=None,
    set_sentry_tags=tags.fill,
    schema_paths=None,
    migration_dirs=None,
    migrations_attached_dbs=None,
    resident=False,
):
    _models_modules = [malwarelib_model]
    if models_modules:
        _models_modules += models_modules

    av_path = Path(__file__).resolve().parent.parent
    _migration_dirs = [av_path / "migrations"]
    if migration_dirs:
        _migration_dirs += migration_dirs

    base_configure(
        init_validator=init_validator,
        validator_cls=validator_cls,
        validate_middleware_wrap=validate_middleware_wrap,
        schema_paths=tuple(base_get_schema_paths())
        + (schema_paths or get_schema_paths()),
        models_modules=_models_modules,
        set_sentry_tags=set_sentry_tags,
        migration_dirs=_migration_dirs,
        migrations_attached_dbs=migrations_attached_dbs,
        resident=resident,
    )
