"""
This program is free software: you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License,
or (at your option) any later version.


This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
See the GNU General Public License for more details.


You should have received a copy of the GNU General Public License
 along with this program.  If not, see <https://www.gnu.org/licenses/>.

Copyright © 2019 Cloud Linux Software Inc.

This software is also available under ImunifyAV commercial license,
see <https://www.imunify360.com/legal/eula>
"""
from pathlib import Path

from defence360agent.contracts.config import FromConfig, FromFlagFile
from defence360agent.contracts.config import Malware as BaseMalwareConfig


class Malware(BaseMalwareConfig):
    PATCH_STORAGE = "/var/imunify360/patch_storage"
    TEMP_CLEANUP_DIR = "/var/imunify360/tmp_cleanup/"
    DETECT_ADMIN_TOOLS = FromConfig("MALWARE_SCANNING", "detect_admin_tools")


class MalwareTune:
    """
    Experimental and testing-only purpose settings
     we don't want to expose to customers.
    """

    USE_JSON_REPORT = FromFlagFile("use_json")
    NO_CHECK_KNOWN_HASHES = FromFlagFile("no_check_known_hashes")
    RAPID_SCAN_BASEDIR_OVERRIDE = FromFlagFile(
        "rapid_scan_basedir_override", coerce=Path, default="/home"
    )
    NO_AUTO_UPGRADE = FromFlagFile("no_auto_upgrade")


class Patchman:
    ENABLED = FromConfig("PATCHMAN", "enable")


class Wordpress:
    SECURITY_PLUGIN_ENABLED = FromConfig(
        "WORDPRESS", "security_plugin_enabled"
    )
