#!/opt/imunify360/venv/bin/python3
"""
This program is free software: you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License,
or (at your option) any later version.


This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
See the GNU General Public License for more details.


You should have received a copy of the GNU General Public License
 along with this program.  If not, see <https://www.gnu.org/licenses/>.

Copyright © 2019 Cloud Linux Software Inc.

This software is also available under ImunifyAV commercial license,
see <https://www.imunify360.com/legal/eula>
"""
from imav import rpc_handlers
from imav.application.settings import configure
from imav.internals.lazy_load import AVSource
from imav.internals.im360 import deploy_im360
from imav.malwarelib.utils import reset_malware_schedule
from imav.server import start
from defence360agent.run import CORE_PLUGINS_PACKAGES
from defence360agent.contracts.plugins import BasePlugin
from defence360agent.internals.cln import subscribe_to_license_changes
from defence360agent.internals.iaid import IndependentAgentIDAPI
from defence360agent.internals.lazy_load import CoreSource
from defence360agent.utils import make_coro, importer, Scope

AV_PLUGINS_PACKAGES = CORE_PLUGINS_PACKAGES + (
    "imav.plugins",
    "imav.malwarelib.plugins",
    "imav.feature_management.plugins",
)


def get_plugins() -> set:
    """Return plugins in unspecified order."""
    importer.load_packages(CoreSource.MESSAGES + AVSource.MESSAGES)
    importer.load_packages(AV_PLUGINS_PACKAGES)
    # use lexicographical order (but don't rely on it in code)
    return sorted(
        [
            plugin
            for plugin in BasePlugin.get_active_plugins()
            if plugin.SCOPE is not Scope.IM360
        ],
        key=lambda item: f"{item.__module__}.{item.__name__}",
    )


async def init_actions():
    subscribe_to_license_changes(make_coro(reset_malware_schedule))
    subscribe_to_license_changes(deploy_im360)
    subscribe_to_license_changes(IndependentAgentIDAPI.reactivate)
    IndependentAgentIDAPI.add_initial_task()
    rpc_handlers.init()


def run():
    configure()
    plugins = get_plugins()
    start(plugins, init_actions)


if __name__ == "__main__":
    run()
