"""
This program is free software: you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License,
or (at your option) any later version.


This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
See the GNU General Public License for more details.


You should have received a copy of the GNU General Public License
 along with this program.  If not, see <https://www.gnu.org/licenses/>.

Copyright © 2019 Cloud Linux Software Inc.

This software is also available under ImunifyAV commercial license,
see <https://www.imunify360.com/legal/eula>
"""
from imav.rpc_tools.middleware import add_malicious_count
from defence360agent.contracts.config import UserType
from defence360agent.rpc_tools.middleware import max_count
from defence360agent.simple_rpc.schema import (
    init_validator as init_base_validator,
)


def init_validator(schema_validator, validate_middleware, schema_paths):
    imav_middleware = {
        ("malware", "ignore", "list"): [
            # need for backward compatibility
            # convert result -> tuple (max_items, items) ->
            # dict {max_items:<int>, items:[...]}
            (max_count, (UserType.ROOT, UserType.NON_ROOT))
        ],
        ("malware", "malicious", "list"): [
            (add_malicious_count, (UserType.ROOT, UserType.NON_ROOT)),
            (max_count, (UserType.ROOT, UserType.NON_ROOT)),
        ],
        ("malware", "history", "list"): [
            (max_count, (UserType.ROOT, UserType.NON_ROOT))
        ],
        ("malware", "user", "list"): [
            (add_malicious_count, (UserType.ROOT, UserType.NON_ROOT)),
            (max_count, (UserType.ROOT, UserType.NON_ROOT)),
        ],
        ("malware", "suspicious", "list"): [
            (max_count, (UserType.ROOT, UserType.NON_ROOT))
        ],
        ("malware", "on-demand", "list"): [
            (max_count, (UserType.ROOT, UserType.NON_ROOT))
        ],
        ("malware", "on-demand", "list-user"): [
            (max_count, (UserType.ROOT, UserType.NON_ROOT))
        ],
        ("vulnerabilities", "file", "list"): [
            (max_count, (UserType.ROOT, UserType.NON_ROOT)),
        ],
        ("vulnerabilities", "user", "list"): [
            (max_count, (UserType.ROOT, UserType.NON_ROOT)),
        ],
    }
    validator, middleware, middleware_exclude = init_base_validator(
        schema_validator, validate_middleware, schema_paths
    )
    middleware.update(imav_middleware)
    return validator, middleware, middleware_exclude
