"""
This program is free software: you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License,
or (at your option) any later version.


This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
See the GNU General Public License for more details.


You should have received a copy of the GNU General Public License
 along with this program.  If not, see <https://www.gnu.org/licenses/>.

Copyright © 2019 Cloud Linux Software Inc.

This software is also available under ImunifyAV commercial license,
see <https://www.imunify360.com/legal/eula>
"""
import logging

from defence360agent.rpc_tools.lookup import RootEndpoints, bind
from defence360agent.internals.iaid import (
    IndependentAgentIDAPI,
    IAIDTokenError,
)
from defence360agent.utils import Scope


logger = logging.getLogger(__name__)


class AuthCloud(RootEndpoints):
    SCOPE = Scope.AV_IM360

    @bind("auth-cloud")
    async def get_iaid_token(self):
        token = await IndependentAgentIDAPI.get_token()
        return {"items": token}

    @bind("auth-cloud-refresh-token")
    async def refresh_iaid_token(self):
        logger.info("Received RPC request to refresh IAID token")
        try:
            # Call login to refresh the token
            await IndependentAgentIDAPI.login()
            logger.info("IAID token refresh initiated successfully via RPC")
            return
        except IAIDTokenError as e:
            logger.error(
                f"Failed to refresh IAID token via RPC: {e}", exc_info=True
            )
            raise ValueError(f"Failed to refresh token: {str(e)}")
        except Exception as e:
            logger.error(
                f"Unexpected error during IAID token refresh via RPC: {e}",
                exc_info=True,
            )
            raise ValueError(f"Unexpected error: {str(e)}")
