"""
This program is free software: you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License,
or (at your option) any later version.


This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
See the GNU General Public License for more details.


You should have received a copy of the GNU General Public License
 along with this program.  If not, see <https://www.gnu.org/licenses/>.

Copyright © 2019 Cloud Linux Software Inc.

This software is also available under ImunifyAV commercial license,
see <https://www.imunify360.com/legal/eula>
"""
import re

LOG_AND_MAIL_REGEX = (
    r"/sess\_\w*$",
    r"/stat/usage\_\w+\.html",
    r"/stat/site\_\w+\.html",
    r"/webstat/awstats.*\.txt",
    r"/awstats/awstats.*\.txt",
    r"/awstats/.{1,80}\.pl",
    r"/awstats/.{1,80}\.html",
    r"/logs/error\_log\..*",
    r"/logs/xferlog\..*",
    r"/logs/access\_log\..*",
    r"/domlogs/.+",
    r"/logs/cron\..*",
    r"/logs/exceptions/.+\.log(?:\.\d)?(?:\.gz)?$",
    r"/mail(?:/[^/]+)*/[^,]+,S=[^,]+,W=.+",
    r"/mail(?:/[^/]+)*/[^,]+,S=.+",
    r"/mail(?:/[^/]+)*/storage/u\.[0-9]+",
    r"/mail(?:/[^/]+)*/storage/m\.[0-9]+",
    r"/Maildir(?:/[^/]+)*/[^,]+,S=[^,]+,W=.+",
    r"/Maildir(?:/[^/]+)*/[^,]+,S=.+",
    r"^/var/ossec/.*",
)

IMUNIFY_LOG_REGEX = (
    r"/var/log/imunify360/acronis-installer\.log$",
    r"/var/log/imunify360/console\.log(?:\.\d)?(?:\.gz)?$",
    r"/var/log/imunify360/debug\.log$",
    r"/var/log/imunify360/error\.log$",
    r"/var/log/install-mod\_remoteip\.log(?:\.\d{1.4})?(?:\.pid)?r$",
    r"/var/log/imunify360/malware\_scan\_\d{10}\.log$",
    r"/var/log/imunify360/network\.log$",
    r"/var/log/imunify360/process\_message\.log$",
    r"/var/log/imunify360-webshield/access.log(?:-\d{8})?(?:.gz)?$",
    r"/var/log/imunify360-webshield/error.log(?:-\d{8})?(?:.gz)?$",
    r"/.revisium_antivirus_cache/.revisium\d+/",
    r"/admin/plib/modules/revisium-antivirus/library/externals/",
)

BYTES_TO_READ = 50

REGEX_IGNORE = [*map(re.compile, LOG_AND_MAIL_REGEX + IMUNIFY_LOG_REGEX)]


def check_log_and_mail(data) -> bool:
    """
    Check if file extension matches log file extension
    """
    for regex_obj in REGEX_IGNORE:
        if regex_obj.search(data):
            return True
    return False
