"""
This program is free software: you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License,
or (at your option) any later version.


This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
See the GNU General Public License for more details.


You should have received a copy of the GNU General Public License
 along with this program.  If not, see <https://www.gnu.org/licenses/>.

Copyright © 2019 Cloud Linux Software Inc.

This software is also available under ImunifyAV commercial license,
see <https://www.imunify360.com/legal/eula>
"""
from functools import lru_cache
from pathlib import Path

from defence360agent.utils import OsReleaseInfo


@lru_cache(1)
def crontab_path() -> Path:
    if OsReleaseInfo.is_ubuntu() or OsReleaseInfo.is_debian():
        return Path("/var/spool/cron/crontabs")
    return Path("/var/spool/cron")


def get_crontab(user: str) -> str:
    return str(crontab_path() / user)


def is_crontab(path: Path) -> bool:
    return path.parent == crontab_path()


def in_crontab(path: Path) -> bool:
    try:
        path.relative_to(crontab_path())
        return True
    except ValueError:
        return False
