"""
This program is free software: you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License,
or (at your option) any later version.


This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
See the GNU General Public License for more details.


You should have received a copy of the GNU General Public License
 along with this program.  If not, see <https://www.gnu.org/licenses/>.

Copyright © 2019 Cloud Linux Software Inc.

This software is also available under ImunifyAV commercial license,
see <https://www.imunify360.com/legal/eula>
"""
from defence360agent.contracts.permissions import (
    ms_imunify_patch_eligible_to_purchase,
)
from defence360agent.rpc_tools.lookup import CommonEndpoints, bind
from imav.contracts.messages import RefreshImunifyPatchSubscription


class ImunifyPatchSubscriptionsEndpoints(CommonEndpoints):
    @bind("imunify-patch", "subscriptions", "refresh")
    async def refresh_subscriptions(self):
        if await ms_imunify_patch_eligible_to_purchase():
            await self._sink.process_message(RefreshImunifyPatchSubscription())
