"""
This program is free software: you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License,
or (at your option) any later version.


This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
See the GNU General Public License for more details.


You should have received a copy of the GNU General Public License
 along with this program.  If not, see <https://www.gnu.org/licenses/>.

Copyright © 2019 Cloud Linux Software Inc.

This software is also available under ImunifyAV commercial license,
see <https://www.imunify360.com/legal/eula>
"""
import logging

from defence360agent.contracts.messages import MessageType
from defence360agent.contracts.plugins import (
    MessageSink,
    MessageSource,
    expect,
)
from imav.malwarelib.scan.queue_supervisor_sync import (
    QueueSupervisorSync,
)

logger = logging.getLogger(__name__)


class QueueSupervisor(MessageSink, MessageSource):
    supervisor = loop = sink = None

    async def create_sink(self, loop):
        self.loop = loop

    async def create_source(self, loop, sink):
        supervisor = QueueSupervisorSync(loop=loop, sink=sink)
        QueueSupervisor.supervisor = supervisor
        QueueSupervisor.loop = loop
        QueueSupervisor.sink = sink
        # If the loop was broken (e.g. after restarting the application)
        await sink.process_message(MessageType.MalwareScanQueueRecheck())

    @expect(MessageType.MalwareScanQueuePut)
    async def put(self, message):
        await self.supervisor.put(message.paths, **message.scan_args)

    @expect(MessageType.MalwareScanQueueRemove)
    async def remove(self, message):
        self.supervisor.remove(message.scan_ids)

    @expect(MessageType.MalwareScanQueueRecheck)
    async def next(self, message):
        self.supervisor.recheck()

    @expect(MessageType.MalwareScanQueueStopBackground)
    async def stop_background(self, message):
        self.supervisor.clear_background()

    @expect(MessageType.MalwareScanQueueUpdateStatus)
    async def update_scan_status(self, message):
        await self.supervisor.update_scan_status(
            message.scan_ids, message.status
        )
