"""
This program is free software: you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License,
or (at your option) any later version.


This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
See the GNU General Public License for more details.


You should have received a copy of the GNU General Public License
 along with this program.  If not, see <https://www.gnu.org/licenses/>.

Copyright © 2019 Cloud Linux Software Inc.

This software is also available under ImunifyAV commercial license,
see <https://www.imunify360.com/legal/eula>
"""
import difflib
import os
from io import BufferedIOBase


def get_files_diff(
    a: os.PathLike | BufferedIOBase,
    b: os.PathLike | BufferedIOBase,
) -> bytes:
    """
    Compare a and b; return a delta (bytes) in unified diff format.
    """
    with a if isinstance(a, BufferedIOBase) else open(a, "rb") as file1, (
        b if isinstance(b, BufferedIOBase) else open(b, "rb")
    ) as file2:
        result = b""
        for line in difflib.diff_bytes(difflib.unified_diff, file1, file2):
            result += line
        return result
