#!/opt/imunify360/venv/bin/python3
"""
This program is free software: you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License,
or (at your option) any later version.


This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
See the GNU General Public License for more details.


You should have received a copy of the GNU General Public License
 along with this program.  If not, see <https://www.gnu.org/licenses/>.

Copyright © 2019 Cloud Linux Software Inc.

This software is also available under ImunifyAV commercial license,
see <https://www.imunify360.com/legal/eula>
"""
import logging

from imav.application.settings import configure
from imav.malwarelib.utils import reset_malware_schedule
from imav import rpc_handlers
from defence360agent import defence360
from defence360agent.application import tags
from defence360agent.internals.cln import subscribe_to_license_changes
from defence360agent.utils import importer, make_coro

logger = logging.getLogger(__name__)


def _run():
    configure(set_sentry_tags=tags.cached_fill)
    subscribe_to_license_changes(make_coro(reset_malware_schedule))
    defence360.entrypoint(rpc_handlers.init)


def run():
    # a symlink is used for compatibility
    # /usr/bin/imunify360-agent -> /usr/bin/imunify-antivirus
    # so run IM360 if available
    run_cmd = importer.get(module="im360.cli", name="run", default=_run)
    run_cmd()
