"""
This program is free software: you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License,
or (at your option) any later version.


This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
See the GNU General Public License for more details.


You should have received a copy of the GNU General Public License
 along with this program.  If not, see <https://www.gnu.org/licenses/>.

Copyright © 2019 Cloud Linux Software Inc.

This software is also available under ImunifyAV commercial license,
see <https://www.imunify360.com/legal/eula>

Add Plesk default config file for AV if not exists."""

import shutil
import logging
from pathlib import Path
from defence360agent.subsys.panels.plesk import Plesk
from defence360agent.contracts.config import ANTIVIRUS_MODE

SOURCE = Path(
    "/opt/imunify360/venv/share/imunify360/10_plesk_default_av.config"
)
TARGET = Path(
    "/etc/sysconfig/imunify360/imunify360.config.d/10_plesk_default_av.config"
)

logger = logging.getLogger(__name__)


def migrate(migrator, database, fake=False, **kwargs):
    if fake:
        return

    if not ANTIVIRUS_MODE:
        logger.info("This migration is only relevant for AV installations.")
        return

    if Plesk.is_installed() is False:
        logger.info("This migration is only relevant for Plesk installations.")
        return

    if TARGET.exists():
        logger.info("Plesk default AV config already exists at %s", TARGET)
        return
    shutil.copy2(SOURCE, TARGET)


def rollback(migrator, database, fake=False, **kwargs):
    pass
