"""
This program is free software: you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License,
or (at your option) any later version.


This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
See the GNU General Public License for more details.


You should have received a copy of the GNU General Public License
 along with this program.  If not, see <https://www.gnu.org/licenses/>.

Copyright © 2019 Cloud Linux Software Inc.

This software is also available under ImunifyAV commercial license,
see <https://www.imunify360.com/legal/eula>
"""
import logging
import os

from defence360agent.contracts.config import ConfigFile

logger = logging.getLogger(__name__)


def _patchman_enabled() -> bool:
    """True if old Patchman was activated"""

    return all(
        [
            os.path.isfile("/etc/patchman/license/patchman.crt"),
            os.path.isfile("/etc/patchman/license/patchman.key"),
        ]
    )


def migrate(*_, fake=False, config_file=None, **__):
    if fake:
        return

    if enabled := _patchman_enabled():
        config_file = config_file or ConfigFile()

        # Enable/disable Patchman in Imunify config
        conf = config_file.config_to_dict(normalize=False)

        patchman = conf.setdefault("PATCHMAN", {})
        patchman.setdefault("enable", False)
        conf["PATCHMAN"]["enable"] = enabled

        config_file.dict_to_config(conf, validate=False)

    # Imunify will start the service based on the value in config


def rollback(*_, **__):
    pass
