"""
This program is free software: you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License,
or (at your option) any later version.


This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
See the GNU General Public License for more details.


You should have received a copy of the GNU General Public License
 along with this program.  If not, see <https://www.gnu.org/licenses/>.

Copyright © 2019 Cloud Linux Software Inc.

This software is also available under ImunifyAV commercial license,
see <https://www.imunify360.com/legal/eula>
"""
import logging
import subprocess

from defence360agent.subsys.panels.cpanel import cPanel

logger = logging.getLogger(__name__)
events = [
    "MalwareFound",
    "ScanNotScheduled",
    "Generic",
]


# iContact events priority (this enables Icontact events triggering)
def migrate(migrator, database, fake=False, **kwargs):
    if fake:
        return

    if not cPanel.is_installed():
        return
    for ev in events:
        try:
            subprocess.run(
                [
                    "whmapi1",
                    "set_application_contact_event_importance",
                    "app=Imunify",
                    "event=" + ev,
                    "importance=High",
                ]
            )
        except Exception as e:
            logger.warning("Failed to set imporance for %s: %s", ev, str(e))


def rollback(migrator, database, fake=False, **kwargs):
    pass
