"""
This program is free software: you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License,
or (at your option) any later version.


This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
See the GNU General Public License for more details.


You should have received a copy of the GNU General Public License
 along with this program.  If not, see <https://www.gnu.org/licenses/>.

Copyright © 2019 Cloud Linux Software Inc.

This software is also available under ImunifyAV commercial license,
see <https://www.imunify360.com/legal/eula>
"""
import logging
import json
from contextlib import suppress


logger = logging.getLogger(__name__)


class SettingsExtractor:
    """Base class for ex-Revisium and Plesk settings extractors"""

    def __init__(self, key, default):
        self.key = key
        self.default = default

    def _get(self):
        raise NotImplementedError

    def get(self):
        try:
            value = self._get()
        except Exception as e:
            logger.warning("Fail to get %r value: %r", self.key, e)
            return self.default

        with suppress(Exception):
            value = json.loads(value)

        return value
