#!/opt/imunify360/venv/bin/python3

"""
This program is free software: you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License,
or (at your option) any later version.


This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
See the GNU General Public License for more details.


You should have received a copy of the GNU General Public License
 along with this program.  If not, see <https://www.gnu.org/licenses/>.

Copyright © 2019 Cloud Linux Software Inc.

This software is also available under ImunifyAV commercial license,
see <https://www.imunify360.com/legal/eula>
"""
from defence360agent.migrate import run as base_run
from defence360agent.utils import importer
from imav.application.settings import configure


def before_migrations():
    im360_hook = importer.get(
        module="im360.application.settings",
        name="before_migrations",
        default=None,
    )
    if im360_hook is not None:
        im360_hook()


def run():
    """
    Entry point for Imunify service, it is common for AV/IM360.
    """
    suitable_configure = importer.get(
        module="im360.application.settings",
        name="configure",
        default=configure,
    )
    start_pkg = "im360.run_resident"
    if suitable_configure is configure:
        start_pkg = "imav.run"
    before_migrations()
    base_run(start_pkg=start_pkg, configure=suitable_configure)


if __name__ == "__main__":
    run()
