"""
This program is free software: you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License,
or (at your option) any later version.


This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
See the GNU General Public License for more details.


You should have received a copy of the GNU General Public License
 along with this program.  If not, see <https://www.gnu.org/licenses/>.

Copyright © 2019 Cloud Linux Software Inc.

This software is also available under ImunifyAV commercial license,
see <https://www.imunify360.com/legal/eula>
"""
from defence360agent.internals.lazy_load import CoreSource
from defence360agent.rpc_tools.lookup import Endpoints
from defence360agent.utils import importer, Scope

from imav.internals.lazy_load import AVSource


def init() -> None:
    importer.load_packages(CoreSource.MESSAGES + AVSource.MESSAGES)
    importer.load_packages(CoreSource.ENDPOINTS + AVSource.ENDPOINTS)
    for cls in Endpoints.get_active_endpoints():
        # NOTE: some plugins can be used only with IM360
        if cls.SCOPE is not Scope.IM360:
            cls.register_rpc_handlers()
