<template id="theme_template">
	<section id="theme_options">
		<div id="theme_options_inner">
			<div id="theme_options_icon">
				<a href="javascript:;">&#xf013;</a>
			</div>
			<form action="<?php echo $tpl['current_url_pageless']; ?>" method="post" autocomplete="off">
				<div>
					<h1><?php echo __('Options du thème'); ?></h1>
				</div>
				<div id="theme_options_menu">
					<ul>
						<li><a href="javascript:;" data-id="theme_options_style" class="current"><?php echo __('Style'); ?></a></li>
						<li><a href="javascript:;" data-id="theme_options_color"><?php echo __('Couleur'); ?></a></li>
						<li><a href="javascript:;" data-id="theme_options_banner"><?php echo __('Bannière'); ?></a></li>
						<li><a href="javascript:;" data-id="theme_options_background"><?php echo __('Fond'); ?></a></li>
						<li><a href="javascript:;" data-id="theme_options_css">CSS</a></li>
						<li><a href="javascript:;" data-id="theme_options_gallery"><?php echo __('Galerie'); ?></a></li>
						<li><a href="javascript:;" data-id="theme_options_thumbs"><?php echo __('Vignettes'); ?></a></li>
						<li><a href="javascript:;" data-id="theme_options_items"><?php echo __('Photos et vidéos'); ?></a></li>
					</ul>
				</div>
				<div id="theme_options_content">
					<fieldset id="theme_options_style">
						<h2><?php echo __('Style'); ?></h2>
						<p class="field">
							<span class="radio">
								<label><input type="radio" name="theme_style" value="clear" id="theme_style_clear"><?php echo __('Clair'); ?></label>
								<label><input type="radio" name="theme_style" value="dark" id="theme_style_dark"><?php echo __('Sombre'); ?></label>
							</span>
						</p>
						<p class="field">
							<input id="theme_style_change" type="checkbox">
							<label for="theme_style_change"><?php echo __('Autoriser les visiteurs à changer le style'); ?></label>
						</p>
						<h2><?php echo __('Boutons de formulaire'); ?></h2>
						<p class="field">
							<span class="radio">
								<label><input type="radio" name="theme_form_buttons_style" value="1" id="theme_form_buttons_style_1"><?php printf(__('Style %s'), 1); ?></label>
								<label><input type="radio" name="theme_form_buttons_style" value="2" id="theme_form_buttons_style_2"><?php printf(__('Style %s'), 2); ?></label>
							</span>
						</p>
					</fieldset>
					<fieldset id="theme_options_color">
						<h2><?php echo __('Couleur'); ?></h2>
						<p class="field">
							<span class="radio">
								<label><input type="radio" name="theme_color_type" value="palette" id="theme_color_type_palette"><?php echo __('Prédéfinie'); ?></label>
								<label><input type="radio" name="theme_color_type" value="custom" id="theme_color_type_custom"><?php echo __('Personnalisée'); ?></label>
							</span>
						</p>
						<div id="theme_palette"></div>
						<div id="theme_custom_color">
							<div id="theme_color_picker"></div>
							<p class="field" id="theme_colors_code">
								<label for="theme_color_code"><?php echo __('Code couleur :'); ?></label>
								<input id="theme_color_code" type="text" maxlength="7" size="7">
							</p>
						</div>
					</fieldset>
					<fieldset id="theme_options_banner">
						<h2><?php echo __('Bannière'); ?></h2>
						<p class="field" id="theme_banner_type">
							<span class="radio">
								<label><input type="radio" name="theme_banner_type" value="none" id="theme_banner_type_none"><?php echo __('Aucune'); ?></label>
								<label><input type="radio" name="theme_banner_type" value="color" id="theme_banner_type_color"><?php echo __('Couleur'); ?></label>
							</span>
							<span class="sep"></span>
							<span class="radio">
								<label><input type="radio" name="theme_banner_type" value="texture" id="theme_banner_type_texture"><?php echo __('Texture'); ?></label>
								<label><input type="radio" name="theme_banner_type" value="file" id="theme_banner_type_file"><?php echo __('Fichier'); ?></label>
							</span>
						</p>
						<p id="theme_banner_file">
							<span class="theme_file_icons">
								<label for="theme_banner_filename"><?php echo 'images/banners/'; ?></label>
								<a href="javascript:;" data-id="theme_banner_infos" class="infos_icon" title="<?php echo __('Obtenir de l\'aide sur cette fonction'); ?>">&#xea0c;</a>
								<a href="javascript:;" data-dir="banners" title="<?php echo __('Recharger la liste des fichiers'); ?>">&#xe984;</a>
							</span>
							<span class="infos_container" id="theme_banner_infos">
								<?php echo __('Le fichier doit être au format GIF, JPEG, PNG ou WEBP et le nom de fichier ne doit contenir aucun espace, caractère spécial ou accentué.'); ?>
							</span>
							<select id="theme_banner_filename"></select>
						</p>
						<div id="theme_banner_texture" data-type="banner" class="field theme_textures">
							<div class="theme_textures_prev"><span>&#xf104;</span></div>
							<div class="theme_textures_images"></div>
							<div class="theme_textures_next"><span>&#xf105;</span></div>
						</div>
						<p class="field">
							<label for="theme_banner_height"><?php echo __('Hauteur :'); ?></label>
							<span class="range">
								<input id="theme_banner_height" type="range" min="80" max="400" step="10">
								<span></span>
							</span>
						</p>
					</fieldset>
					<fieldset id="theme_options_background">
						<h2><?php echo __('Fond'); ?></h2>
						<p class="field" id="theme_background_type">
							<span class="radio">
								<label><input type="radio" name="theme_background_type" value="none" id="theme_background_type_none"><?php echo __('Aucun'); ?></label>
								<label><input type="radio" name="theme_background_type" value="border" id="theme_background_type_border"><?php echo __('Bordures'); ?></label>
							</span>
							<span class="sep"></span>
							<span class="radio">
								<label><input type="radio" name="theme_background_type" value="texture" id="theme_background_type_texture"><?php echo __('Texture'); ?></label>
								<label><input type="radio" name="theme_background_type" value="file" id="theme_background_type_file"><?php echo __('Fichier'); ?></label>
							</span>
						</p>
						<p id="theme_background_file">
							<span class="theme_file_icons">
								<label for="theme_background_filename"><?php echo 'images/background/'; ?></label>
								<a href="javascript:;" data-id="theme_background_infos" class="infos_icon" title="<?php echo __('Obtenir de l\'aide sur cette fonction'); ?>">&#xea0c;</a>
								<a href="javascript:;" data-dir="background" title="<?php echo __('Recharger la liste des fichiers'); ?>">&#xe984;</a>
							</span>
							<span class="infos_container" id="theme_background_infos">
								<?php echo __('Le fichier doit être au format GIF, JPEG, PNG ou WEBP et le nom de fichier ne doit contenir aucun espace, caractère spécial ou accentué.'); ?>
							</span>
							<select id="theme_background_filename"></select>
						</p>
						<div id="theme_background_texture" data-type="background" class="field theme_textures">
							<div class="theme_textures_prev"><span>&#xf104;</span></div>
							<div class="theme_textures_images"></div>
							<div class="theme_textures_next"><span>&#xf105;</span></div>
						</div>
						<p class="field">
							<input id="theme_background_fixed" type="checkbox">
							<label for="theme_background_fixed"><?php echo __('Fond fixe'); ?></label>
						</p>
						<p class="field">
							<input id="theme_background_bottom_texture" type="checkbox">
							<label for="theme_background_bottom_texture"><?php echo __('Texture pour le bas de page'); ?></label>
						</p>
						<p class="field">
							<input id="theme_background_internal_hatches" type="checkbox">
							<label for="theme_background_internal_hatches"><?php echo __('Fond interne hachuré'); ?></label>
						</p>
					</fieldset>
					<fieldset id="theme_options_css">
						<h2><span><?php echo __('Code CSS personnalisé'); ?><a href="javascript:;" title="<?php echo __('Obtenir de l\'aide sur cette fonction'); ?>" class="infos_icon" data-id="theme_css_infos">&#xea0c;</a></span></h2>
						<div class="infos_container" id="theme_css_infos">
							<p class="field">
								<?php echo __('Utilisez le tag #color pour appliquer la couleur du thème.'); ?>
								<br>
								<?php echo __('Utilisez le tag #gallery_path comme chemin de la galerie.'); ?>
								<br>
								<?php echo __('Utilisez @media (min-width: 1180px) { ... } pour cibler uniquement les écrans larges.'); ?>
								<br>
								<?php echo __('Exemple :'); ?>
							</p>
<pre>
@media (min-width: 1180px)
{
   #gallery #bottom
   {
      border-top: 3px solid #color;
      background-image: url(#gallery_path/images/textures/climpek.png);
   }
}
</pre>
						</div>
						<p class="field">
							<textarea wrap="off" id="theme_css_code" cols="50" rows="10"></textarea>
						</p>
					</fieldset>
					<fieldset id="theme_options_gallery">
						<h2><?php echo __('Largeur de la galerie'); ?></h2>
						<p class="field">
							<span class="radio">
								<label><input type="radio" name="theme_gallery_size" value="small" id="theme_gallery_size_small"><?php echo __('Petite'); ?></label>
								<label><input type="radio" name="theme_gallery_size" value="large" id="theme_gallery_size_large"><?php echo __('Grande'); ?></label>
								<label><input type="radio" name="theme_gallery_size" value="superlarge" id="theme_gallery_size_superlarge"><?php echo __('Très grande'); ?></label>
							</span>
						</p>
						<h2><?php echo __('Texte'); ?></h2>
						<p class="field">
							<label for="theme_text_size"><?php echo __('Taille :'); ?></label>
							<select id="theme_text_size"></select> %
						</p>
						<p class="field">
							<span class="sep"></span>
							<input type="checkbox" id="theme_text_desc_width_limit">
							<label for="theme_text_desc_width_limit"><?php echo __('Limiter la largeur des descriptions'); ?></label>
						</p>
						<h2><?php echo __('Menu'); ?></h2>
						<p class="field">
							<input type="checkbox" id="theme_display_menu">
							<label for="theme_display_menu"><?php echo __('Menu'); ?></label>
							<span class="sep"></span>
							<input type="checkbox" id="theme_display_menu_home">
							<label for="theme_display_menu_home"><?php echo __('Lien vers la page d\'accueil'); ?></label>
							<span class="sep"></span>
						</p>
						<p class="field">
							<label for="theme_menu_width"><?php echo __('Largeur :'); ?></label>
							<span class="range">
								<input id="theme_menu_width" type="range" min="50" max="100" step="5">
								<span></span>
							</span>
						</p>
					</fieldset>
					<fieldset id="theme_options_thumbs">
						<h2><?php echo __('Catégories et albums'); ?></h2>
						<p class="field">
							<span><?php echo __('Taille :'); ?></span><br>
							<span class="radio">
								<label><input type="radio" name="theme_thumbs_cat_size" value="small" id="theme_thumbs_cat_size_small"><?php echo __('Petite'); ?></label>
								<label><input type="radio" name="theme_thumbs_cat_size" value="large" id="theme_thumbs_cat_size_large"><?php echo __('Grande'); ?></label>
							</span>
						</p>
						<p class="field">
							<span><?php echo __('Format :'); ?></span><br>
							<span class="radio">
								<label><input type="radio" name="theme_thumbs_cat_type" value="landscape" id="theme_thumbs_cat_type_landscape"><?php echo __('Paysage'); ?></label>
								<label><input type="radio" name="theme_thumbs_cat_type" value="square" id="theme_thumbs_cat_type_square"><?php echo __('Carré'); ?></label>
								<label><input type="radio" name="theme_thumbs_cat_type" value="portrait" id="theme_thumbs_cat_type_portrait"><?php echo __('Portrait'); ?></label>
							</span>
						</p>
						<h2><?php echo __('Photos et vidéos'); ?></h2>
						<p class="field">
							<span><?php echo __('Taille :'); ?></span><br>
							<span class="radio">
								<label><input type="radio" name="theme_thumbs_items_size" value="small" id="theme_thumbs_items_size_small"><?php echo __('Petite'); ?></label>
								<label><input type="radio" name="theme_thumbs_items_size" value="large" id="theme_thumbs_items_size_large"><?php echo __('Grande'); ?></label>
								<label><input type="radio" name="theme_thumbs_items_size" value="superlarge" id="theme_thumbs_items_size_superlarge"><?php echo __('Très grande'); ?></label>
							</span>
						</p>
						<p class="field">
							<span><?php echo __('Format :'); ?></span><br>
							<span class="radio">
								<label><input type="radio" name="theme_thumbs_items_type" value="standard" id="theme_thumbs_items_type_standard"><?php echo __('Normal'); ?></label>
								<label><input type="radio" name="theme_thumbs_items_type" value="landscape" id="theme_thumbs_items_type_landscape"><?php echo __('Paysage'); ?></label>
								<label><input type="radio" name="theme_thumbs_items_type" value="square" id="theme_thumbs_items_type_square"><?php echo __('Carré'); ?></label>
								<label><input type="radio" name="theme_thumbs_items_type" value="portrait" id="theme_thumbs_items_type_portrait"><?php echo __('Portrait'); ?></label>
							</span>
						</p>
					</fieldset>
					<fieldset id="theme_options_items">
						<h2><?php echo __('Éléments à afficher'); ?></h2>
						<p class="field">
							<input type="checkbox" id="theme_display_item_title">
							<label for="theme_display_item_title"><?php echo __('Titre'); ?></label>
							<span class="sep"></span>
							<input type="checkbox" id="theme_display_item_stats">
							<label for="theme_display_item_stats"><?php echo $tpl['favorites'] ? __('Nombre de vues et de favoris') : __('Nombre de vues'); ?></label>
							<span class="sep"></span>
<?php if ($tpl['users']) : ?>
							<input type="checkbox" id="theme_display_item_user">
							<label for="theme_display_item_user"><?php echo __('Utilisateur'); ?></label>
							<span class="sep"></span>
<?php endif; ?>
							<input type="checkbox" id="theme_display_item_properties">
							<label for="theme_display_item_properties"><?php echo __('Propriétés'); ?></label>
							<span class="sep"></span>
							<input type="checkbox" id="theme_display_item_prev_next">
							<label for="theme_display_item_prev_next">
								<?php echo __('Boutons suivant et précédent'); ?>
								<br>
								&nbsp;&nbsp;&nbsp;&nbsp;<?php echo __('(écrans larges uniquement)'); ?>
							</label>
							<span class="sep"></span>
							<input type="checkbox" id="theme_display_item_pagination_top">
							<label for="theme_display_item_pagination_top">
								<?php echo __('Barre de pagination du haut'); ?>
								<br>
								&nbsp;&nbsp;&nbsp;&nbsp;<?php echo __('(écrans larges uniquement)'); ?>
							</label>
							<span class="sep"></span>
							<input type="checkbox" id="theme_display_item_pagination_bottom">
							<label for="theme_display_item_pagination_bottom"><?php echo __('Barre de pagination du bas'); ?></label>
						</p>
					</fieldset>
				</div>
				<div id="theme_options_buttons">
					<input class="button" type="submit" value="<?php echo __('Enregistrer'); ?>">
					<input class="button" type="button" name="cancel" value="<?php echo __('Annuler'); ?>">
				</div>
			</form>
		</div>
	</section>
</template>