<form class="standard" id="register_form" action="<?php echo $tpl['current_url_pageless']; ?>" method="post" autocomplete="off">
	<h2><?php echo __('Créer un compte'); ?></h2>
<?php if (isset($tpl['report']['success'])) : ?>
	<p class="message_success"><?php echo $tpl['report']['success']; ?></p>
<?php else : ?>
<?php include(__DIR__ . '/report.tpl.php'); ?>
	<p class="field">
		<label for="f_email">Email :</label>
		<input maxlength="255" id="f_email" name="f_email" type="text">
	</p>
	<p class="required field<?php if ($tpl['field_error'] == 'login') : ?> field_error<?php endif; ?>">
		<label for="login"><?php echo __('Nom d\'utilisateur :'); ?></label>
		<input required autofocus value="<?php echo $_POST['login'] ?? ''; ?>" id="login" name="login" type="text" maxlength="<?php echo $tpl['register']['fields']['login']['maxlength']; ?>" class="large">
	</p>
	<p class="required field<?php if ($tpl['field_error'] == 'password') : ?> field_error<?php endif; ?>">
		<label for="password"><?php printf(__('Mot de passe (%s caractères minimum) :'), $tpl['register']['password']['minlength']); ?></label>
		<input data-password-view="1" required value="<?php echo $_POST['password'] ?? ''; ?>" id="password" name="password" type="password" maxlength="<?php echo $tpl['register']['fields']['password']['maxlength']; ?>" class="large">
	</p>
	<p class="required field<?php if ($tpl['field_error'] == 'password_confirm') : ?> field_error<?php endif; ?>">
		<label for="password_confirm"><?php echo __('Confirmez le mot de passe :'); ?></label>
		<input data-password-view="1" required value="<?php echo $_POST['password_confirm'] ?? ''; ?>" id="password_confirm" name="password_confirm" type="password" maxlength="<?php echo $tpl['register']['fields']['password']['maxlength']; ?>" class="large">
	</p>
<?php if ($tpl['register']['fields_infos']) : ?>
	<br>
<?php if ($tpl['register']['fields']['nickname']['required']) : ?>
	<p class="required field<?php if ($tpl['field_error'] == 'nickname') : ?> field_error<?php endif; ?>">
		<label for="nickname"><?php echo __('Pseudonyme (s\'affichera à la place du nom d\'utilisateur) :'); ?></label>
		<input required value="<?php echo $_POST['nickname'] ?? ''; ?>" id="nickname" name="nickname" type="text" maxlength="<?php echo $tpl['register']['fields']['nickname']['maxlength']; ?>" class="large">
	</p>
<?php endif; ?>
<?php if ($tpl['register']['fields']['name']['required']) : ?>
	<p class="required field<?php if ($tpl['field_error'] == 'name') : ?> field_error<?php endif; ?>">
		<label for="name"><?php echo __('Nom :'); ?></label>
		<input required value="<?php echo $_POST['name'] ?? ''; ?>" id="name" name="name" type="text" maxlength="<?php echo $tpl['register']['fields']['name']['maxlength']; ?>" class="large">
	</p>
<?php endif; ?>
<?php if ($tpl['register']['fields']['firstname']['required']) : ?>
	<p class="required field<?php if ($tpl['field_error'] == 'firstname') : ?> field_error<?php endif; ?>">
		<label for="firstname"><?php echo __('Prénom :'); ?></label>
		<input required value="<?php echo $_POST['firstname'] ?? ''; ?>" id="firstname" name="firstname" type="text" maxlength="<?php echo $tpl['register']['fields']['firstname']['maxlength']; ?>" class="large">
	</p>
<?php endif; ?>
<?php if ($tpl['register']['fields']['gender']['required']) : ?>
	<p class="required field<?php if ($tpl['field_error'] == 'gender') : ?> field_error<?php endif; ?>">
		<label for="gender"><?php echo __('Genre :'); ?></label>
		<br>
		<select required name="gender" id="gender">
<?php foreach ($tpl['register']['gender'] as &$i) : ?>
			<option<?php if (isset($_POST['gender']) && $_POST['gender'] == $i['value']) : ?> selected<?php endif; ?> value="<?php echo $i['value']; ?>"><?php echo $i['text']; ?></option>
<?php endforeach; ?>
		</select>
	</p>
<?php endif; ?>
<?php if ($tpl['register']['fields']['birthdate']['required']) : ?>
		<p class="required field<?php if ($tpl['field_error'] == 'birthdate') : ?> field_error<?php endif; ?>">
			<label for="birthdate_day"><?php echo __('Date de naissance :'); ?></label>
			<br>
			<select required class="day" name="birthdate_day" id="birthdate_day">
				<option value=""><?php echo __('Jour'); ?></option>
<?php for ($n = 1; $n <= 31; $n++) : ?>
				<option<?php if (isset($_POST['birthdate_day']) && $_POST['birthdate_day'] == $n) : ?> selected<?php endif; ?> value="<?php echo $n; ?>"><?php echo $n; ?></option>
<?php endfor; ?>
			</select>
			<select required class="month" name="birthdate_month">
				<option value=""><?php echo __('Mois'); ?></option>
<?php for ($n = 1; $n <= 12; $n++) : ?>
				<option<?php if (isset($_POST['birthdate_month']) && $_POST['birthdate_month'] == $n) : ?> selected<?php endif; ?> value="<?php echo $n; ?>"><?php echo $tpl['locale']('month:' . $n); ?></option>
<?php endfor; ?>
			</select>
			<select required class="year" name="birthdate_year">
				<option value=""><?php echo __('Année'); ?></option>
<?php for ($n = date('Y') - 110; $n <= date('Y') - 10; $n++) : ?>
				<option<?php if (isset($_POST['birthdate_year']) && $_POST['birthdate_year'] == $n) : ?> selected<?php endif; ?> value="<?php echo $n; ?>"><?php echo $n; ?></option>
<?php endfor; ?>
			</select>
			&nbsp;
			<a class="js date_reset" href="javascript:;"><?php echo __('Effacer'); ?></a>
		</p>
<?php endif; ?>
<?php if ($tpl['register']['fields']['location']['required']) : ?>
	<p class="required field<?php if ($tpl['field_error'] == 'location') : ?> field_error<?php endif; ?>">
		<label for="location"><?php echo __('Localisation :'); ?></label>
		<input required value="<?php echo $_POST['location'] ?? ''; ?>" id="location" name="location" type="text" maxlength="<?php echo $tpl['register']['fields']['location']['maxlength']; ?>" class="large">
	</p>
<?php endif; ?>
<?php if ($tpl['register']['fields']['email']['required']) : ?>
	<p class="required field<?php if ($tpl['field_error'] == 'email') : ?> field_error<?php endif; ?>">
		<label for="email"><?php echo __('Courriel (ne sera pas visible) :'); ?></label>
		<input required value="<?php echo $_POST['email'] ?? ''; ?>" id="email" name="email" type="email" maxlength="<?php echo $tpl['register']['fields']['email']['maxlength']; ?>" class="large">
	</p>
<?php if ($tpl['config']('users_registration_valid_email')) : ?>
	<p class="message_info"><?php echo __('Veuillez entrer une adresse valide, celle-ci sera utilisée pour confirmer votre inscription.'); ?></p>
<?php endif; ?>
<?php endif; ?>
<?php if ($tpl['register']['fields']['website']['required']) : ?>
	<p class="required field<?php if ($tpl['field_error'] == 'website') : ?> field_error<?php endif; ?>">
		<label for="website"><?php echo __('Site Web :'); ?></label>
		<input required value="<?php echo $_POST['website'] ?? ''; ?>" id="website" name="website" type="url" maxlength="<?php echo $tpl['register']['fields']['website']['maxlength']; ?>" class="large">
	</p>
<?php endif; ?>
<?php if ($tpl['register']['fields']['description']['required']) : ?>
	<p class="required field<?php if ($tpl['field_error'] == 'description') : ?> field_error<?php endif; ?>">
		<label for="description"><?php printf(__('Description (%s caractères maximum) :'), $tpl['register']['fields']['description']['maxlength']); ?></label>
		<textarea required maxlength="<?php echo $tpl['register']['fields']['description']['maxlength']; ?>" rows="4" cols="25" id="description" name="description"><?php echo $_POST['description'] ?? ''; ?></textarea>
	</p>
<?php endif; ?>
<?php for ($n = 1; $n <= 5; $n++) : ?>
<?php if ($tpl['register']['fields']['custom_' . $n]['required']) : ?>
	<p class="required field<?php if ($tpl['field_error'] == 'custom_' . $n) : ?> field_error<?php endif; ?>">
		<label for="custom_<?php echo $n; ?>"><?php echo $tpl['register']['fields']['custom_' . $n]['name']; ?></label>
		<input required value="<?php echo $_POST['custom_' . $n] ?? ''; ?>" id="custom_<?php echo $n; ?>" name="custom_<?php echo $n; ?>" type="text" maxlength="<?php echo $tpl['register']['fields']['custom_' . $n]['maxlength']; ?>" class="large">
	</p>
<?php endif; ?>
<?php endfor; ?>
<?php endif; ?>
<?php if (isset($tpl['register']['password_validation'])) : ?>
	<br>
	<p class="required field<?php if ($tpl['field_error'] == 'password_validation') : ?> field_error<?php endif; ?>">
		<label for="password_validation"><?php echo __('Pour valider votre inscription, vous devez entrer un mot de passe :'); ?></label>
		<input data-password-view="1" required value="<?php echo $_POST['password_validation'] ?? ''; ?>" id="password_validation" name="password_validation" type="password" maxlength="64" class="large">
<?php if (!empty($tpl['register']['password_validation_text'])) : ?>
		<span id="password_validation_text">
			<span><?php echo __('Indice pour le mot de passe :'); ?></span>
			<span><?php echo $tpl['register']['password_validation_text']; ?></span>
		</span>
<?php endif; ?>
	</p>
<?php endif; ?>
	<br>
	<p class="message_info"><?php echo __('Les champs marqués d\'un astérisque sont obligatoires.'); ?></p>
	<p id="submit">
		<input name="anticsrf" type="hidden" value="<?php echo $tpl['anticsrf'](); ?>">
		<input class="button" name="register" type="submit" value="<?php echo __('Enregistrer'); ?>">
	</p>
<?php endif; ?>
</form>