<?php
declare(strict_types = 1);

/**
 * Gestion de la galerie.
 *
 * @license https://www.gnu.org/licenses/gpl-3.0.html
 * @link https://www.igalerie.org/
 */
require_once(__DIR__ . '/includes/prepend.php');
require_once(__DIR__ . '/includes/gallery/classes/Gallery.class.php');

// Démarrage de la galerie.
Gallery::start();

// Chargement du template.
Template::start();
$tpl =& Template::$data;
$theme = Config::$params['theme_template'];
require_once(sprintf(__DIR__ . '/template/%s/%s.tpl.php',
	preg_match(App::TPL_REGEXP, $theme) ? $theme : 'default',
	Config::$params['gallery_closed'] ? 'closed' : 'index'
));
?>