<?php
declare(strict_types = 1);

class_exists('DB') || die;

require_once(__DIR__ . '/classes/AdminCategory.class.php');

template:
{
	AdminCategory::tplSection('category_thumb_new');

	$types = Item::getTypesSupported('image');
	$text_limits = sprintf(__('Formats acceptés : %s.'), implode(', ', $types['text']));
	$text_limits .= ' ' . sprintf(
		__('Poids maximum : %s.'),
		L10N::formatFilesize(Utility::getUploadMaxFilesize())
	);
	$text_limits .= ' ' . sprintf(
		__('Dimensions maximum : %s x %s pixels.'),
		Config::$params['upload_maxwidth'], Config::$params['upload_maxheight']
	);
	Template::set('upload',
	[
		'filetypes' => $types['mime'],
		'text_limits' => $text_limits
	]);
}

update:
{
	AdminCategory::thumbChange();

	AdminCategory::thumbExternal();

	AdminCategory::thumbMethod();
}

get_data:
{
	AdminCategory::getInfos();

	AdminCategory::getThumbItems();

	AdminAlbums::getCategoriesLists();
}
?>