<?php
declare(strict_types = 1);

/**
 * Envoi le contenu d'un fichier.
 *
 * @license https://www.gnu.org/licenses/gpl-3.0.html
 * @link https://www.igalerie.org/
 */

$gets = ['file', 'key'];
require_once(__DIR__ . '/includes/prepend.php');

// Vérification du format des paramètres.
if (!isset($_GET['file']) || !preg_match('`^.{1,255}$`i', $_GET['file'])
 || !isset($_GET['key'])  || !preg_match('`^[a-f0-9]{32}$`', $_GET['key']))
{
	die(App::httpResponse(400));
}

// Vérification de la clé de sécurité.
if (!Security::fileKeyVerify([$_GET['file']], $_GET['key']))
{
	die(App::httpResponse(403));
}

// Envoi du fichier.
$dir = $_GET['file'][0] == '/' ? GALLERY_ROOT : CONF_ALBUMS_PATH . '/';
if (!file_exists($dir . $_GET['file']))
{
	die(App::httpResponse(404));
}
if (preg_match('`\.(' . implode('|', Video::EXT_ARRAY) . ')$`i', $_GET['file']))
{
	Video::read($dir . $_GET['file'], isset($download));
}
else
{
	Image::read($dir . $_GET['file'], isset($download));
}
?>