<?php
$not_available = FALSE;
foreach ($tpl['pages'] as &$i)
{
	if (!in_array($i['custom'] ? 'custom' : $i['name'], THEME_PAGES))
	{
		$not_available = TRUE;
		break;
	}
}
?>
<?php if ($not_available) : ?>
<div class="report_classic">
	<div class="report_msg report_info">
		<p><?php echo __('Certaines pages ne sont pas disponibles avec le thème actuel.'); ?></p>
	</div>
</div>
<?php endif; ?>
<form id="obj_mini_form" action="<?php echo $tpl['current_url_pageless']; ?>" method="post">
	<p class="field">
		<a href="<?php echo $tpl['link']('new-page'); ?>"><?php echo __('Créer une nouvelle page'); ?></a>
	</p>
	<div>
<?php foreach ($tpl['pages'] as &$i) : ?>
		<div id="i_<?php echo $i['id']; ?>" class="obj_mini <?php if ($i['status']) : ?>selected<?php endif; ?> selectable_class">
			<div class="obj_mini_body">
				<p class="obj_mini_selectable<?php if (!$i['disabled']) : ?> selectable_zone<?php endif; ?>">
					<input type="hidden" name="items[<?php echo $i['name']; ?>][page]" value="1">
					<input
						class="selectable"
						<?php if ($i['disabled']) : ?>disabled<?php endif; ?>
						<?php if ($i['status']) : ?>checked="checked"<?php endif; ?>
						name="items[<?php echo $i['name']; ?>][activated]"
						type="checkbox">
				</p>
				<p class="obj_mini_sortable">
					<img src="<?php echo $tpl['admin']['style']['path']; ?>/icons/16x16/move-up-down.png" height="16" width="16">
				</p>
				<p class="obj_mini_title">
					<span>
<?php if ($i['link']) : ?>
						<a href="<?php echo $i['link']; ?>"><?php echo $i['title']; ?></a>
<?php else : ?>
						<?php echo $i['title']; ?>
<?php endif; ?>
					</span>
				</p>
<?php if ($i['custom']) : ?>
				<p class="obj_mini_action">
					<span class="icon icon_delete" data-action="delete">
						<a class="js" href="javascript:;">
							<span><?php echo __('Supprimer'); ?></span>
						</a>
					</span>
				</p>
<?php endif; ?>
			</div>
		</div>
<?php endforeach; ?>
	</div>
	<div id="submit">
		<div>
			<input name="anticsrf" type="hidden" value="<?php echo $tpl['anticsrf'](); ?>">
			<input name="serial" type="hidden">
			<input type="submit" value="<?php echo __('Enregistrer'); ?>">
		</div>
	</div>
</form>

<script nonce="<?php echo CSP_NONCE; ?>" type="text/javascript">
var confirm_delete = "<?php echo $tpl['php2js'](__('Supprimer cette page ?')); ?>";
</script>