<!DOCTYPE html>
<html lang="<?php echo $tpl['lang']; ?>" class="nojs">

<head>
	<title><?php echo $tpl['page']['title']; ?> - <?php echo $tpl['app']['name']; ?></title>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width">
	<link rel="stylesheet" type="text/css" media="screen" title="style" href="<?php echo $tpl['admin']['style']['path']; ?>/style.css?<?php echo $tpl['version_key']; ?>">
	<script type="text/javascript" src="<?php echo $tpl['gallery']['path']; ?>/js/jquery/jquery.js?<?php echo $tpl['version_key']; ?>"></script>
<?php if (in_array($_GET['section'], ['album-thumb', 'category-thumb', 'item-thumb'])) : ?>
	<script type="text/javascript" src="<?php echo $tpl['gallery']['path']; ?>/js/jquery/imgareaselect/imgareaselect.js?<?php echo $tpl['version_key']; ?>"></script>
<?php endif; ?>
<?php if (in_array($_GET['section'], ['album', 'category', 'category-items', 'item-replace', 'items-pending'])) : ?>
<?php if (in_array($_GET['section'], ['album', 'item-replace']) && !isset($_GET['filter'])) : ?>
	<script type="text/javascript" src="<?php echo $tpl['gallery']['path']; ?>/js/upload.js?<?php echo $tpl['version_key']; ?>"></script>
<?php endif; ?>
<?php if ($tpl['options']['display'] == 'grid') : ?>
	<script type="text/javascript" src="<?php echo $tpl['admin']['template']['path']; ?>/js/grid.js?<?php echo $tpl['version_key']; ?>"></script>
<?php endif; ?>
<?php endif; ?>
	<script type="text/javascript" src="<?php echo $tpl['gallery']['path']; ?>/js/videocaptures.js?<?php echo $tpl['version_key']; ?>"></script>
	<script type="text/javascript" src="<?php echo $tpl['admin']['template']['path']; ?>/js/admin.js?<?php echo $tpl['version_key']; ?>"></script>
	<script nonce="<?php echo CSP_NONCE; ?>" type="text/javascript">
	var html = document.querySelector('html');
	html.classList.remove('nojs');
	html.classList.add('js');
	var anticsrf = "<?php echo $tpl['anticsrf'](); ?>";
<?php if ($tpl['video_captures']) : ?>
	var captures = [];
<?php foreach ($tpl['video_captures'] as &$i) : ?>
	captures.push({
		hash:'<?php echo $i['hash']; ?>',
		key:'<?php echo $i['key']; ?>',
		id:'<?php echo $i['id']; ?>',
		path:'<?php echo $i['path']; ?>'
	});
<?php endforeach; ?>
<?php endif; ?>
	var admin_path = "<?php echo $tpl['admin']['path']; ?>";
	var gallery_path = "<?php echo $tpl['gallery']['path']; ?>";
	var help_html = '<section class="help_context" id="help_textarea_html"><div>'
		+ '<div class="help_title">'
		+ '<h1><span class="icon icon_help"><?php echo $tpl['php2js'](__('Code HTML')); ?><\/span><\/h1>'
		+ '<span class="help_close"><\/span>'
		+ '<\/div>'
		+ '<div class="help_content">'
		+ '<p><?php echo $tpl['php2js'](__('Balises HTML autorisées :')); ?><\/p>'
		+ '<pre><?php echo $tpl['allowed_tags']; ?>.<\/pre>'
		+ '<p><?php echo $tpl['php2js'](__('Attributs de balises autorisés :')); ?><\/p>'
		+ '<pre><?php echo $tpl['allowed_attrs']; ?>.<\/pre>'
		+ '<\/div>'
		+ '<\/div><\/section>';
	var q = "<?php echo $_GET['q']; ?>";
	var q_filter = "<?php echo $_GET['filter'] ?? ''; ?>";
	var q_pageless = "<?php echo $_GET['q_pageless']; ?>";
	var style_path = "<?php echo $tpl['admin']['style']['path']; ?>";
<?php if (in_array($_GET['section'], ['album', 'album-geolocation', 'category', 'category-items', 'item-geolocation']) || $_GET['q'] == 'page/worldmap') : ?>
	var leaflet_css_file = 'https://unpkg.com/leaflet@1.9.4/dist/leaflet.css';
	var leaflet_css_file_integrity = 'sha256-p4NxAoJBhIIN+hmNHrzRCf9tD/miZyoHS5obTRR9BMY=';
	var leaflet_js_file = 'https://unpkg.com/leaflet@1.9.4/dist/leaflet.js';
	var leaflet_js_file_integrity = 'sha256-20nQCchB9co0qIjJZRGuk2/Z9VM+kNiyxNV1lvTlZBo=';
	var leaflet_search_css_file = 'https://unpkg.com/leaflet-geosearch@3.11.0/dist/geosearch.css';
	var leaflet_search_css_file_integrity = 'sha256-p+jKGIZe6dprRIMUXUr2GApehNzk6FJ0I7SFU20mQVs=';
	var leaflet_search_js_file = 'https://unpkg.com/leaflet-geosearch@3.11.0/dist/geosearch.umd.js';
	var leaflet_search_js_file_integrity = 'sha256-6q34VDIvgjqtfz57RofJyB3lyle8ewD6QtWhCaf2d5Q=';
	var leaflet_map_text = "<?php echo $tpl['php2js'](__('Plan')); ?>";
	var leaflet_satellite_text = "<?php echo $tpl['php2js'](__('Satellite')); ?>";
	var text_marker_add = "<?php echo $tpl['php2js'](__('Ajouter le marqueur')); ?>";
	var text_marker_delete = "<?php echo $tpl['php2js'](__('Supprimer le marqueur')); ?>";
<?php endif; ?>
	</script>

<?php $head = __DIR__ . '/custom/head.tpl.php'; if (file_exists($head)) : ?><?php include_once($head); ?><?php endif; ?>
</head>

<body id="section_<?php echo $tpl['section_id']; ?>"<?php if (isset($tpl['options']['display'])) : ?> class="<?php echo $tpl['options']['display']; ?>"<?php endif; ?>>
	<div id="wrapper">
		<div id="menu">
		<div id="menu_inner">
			<a rel="menu" class="js_menu_link" href="javascript:;"><?php echo __('Fermer'); ?></a>
			<h1><?php echo $tpl['app']['name']; ?></h1>
			<nav>
				<h1>FTP</h1>
				<ul>
					<li<?php if ($tpl['section'] == 'scan') : ?> class="current"<?php endif; ?>><a href="<?php echo $tpl['link']('scan'); ?>"><?php echo __('Ajout de fichiers'); ?></a></li>
				</ul>
			</nav>
			<nav>
				<h1><?php echo __('Objets'); ?></h1>
				<ul>
					<li<?php if ($tpl['section'] == 'albums') : ?> class="current"<?php endif; ?>><a href="<?php echo $tpl['link']('category/1'); ?>"><?php echo __('Albums'); ?></a></li>
					<li<?php if (substr($tpl['section'], 0, 8) == 'comments') : ?> class="current"<?php endif; ?>><a href="<?php echo $tpl['link']('comments'); ?>"><?php echo __('Commentaires'); ?></a></li>
					<li<?php if ($tpl['section'] == 'votes') : ?> class="current"<?php endif; ?>><a href="<?php echo $tpl['link']('votes'); ?>"><?php echo __('Votes'); ?></a></li>
					<li<?php if ($tpl['section'] == 'tags') : ?> class="current"<?php endif; ?>><a href="<?php echo $tpl['link']('tags'); ?>"><?php echo __('Tags'); ?></a></li>
					<li<?php if (substr($tpl['section'], 0, 7) == 'cameras') : ?> class="current"<?php endif; ?>><a href="<?php echo $tpl['link']('cameras-models'); ?>"><?php echo __('Appareils photos'); ?></a></li>
					<li<?php if ($tpl['section'] == 'groups' || substr($tpl['section'], 0, 5) == 'users') : ?> class="current"<?php endif; ?>><a href="<?php echo $tpl['link']('users'); ?>"><?php echo __('Utilisateurs'); ?></a></li>
				</ul>
			</nav>
			<nav>
				<h1><?php echo __('Réglages'); ?></h1>
				<ul>
					<li<?php if ($tpl['section'] == 'pages') : ?> class="current"<?php endif; ?>><a href="<?php echo $tpl['link']('pages'); ?>"><?php echo __('Pages'); ?></a></li>
					<li<?php if ($tpl['section'] == 'features') : ?> class="current"<?php endif; ?>><a href="<?php echo $tpl['link']('features'); ?>"><?php echo __('Fonctionnalités'); ?></a></li>
					<li<?php if (substr($tpl['section'], 0, 7) == 'options') : ?> class="current"<?php endif; ?>><a href="<?php echo $tpl['link']('options-gallery'); ?>"><?php echo __('Options'); ?></a></li>
					<li<?php if ($tpl['section'] == 'themes') : ?> class="current"<?php endif; ?>><a href="<?php echo $tpl['link']('themes'); ?>"><?php echo __('Thèmes'); ?></a></li>
					<li<?php if ($tpl['section'] == 'maintenance') : ?> class="current"<?php endif; ?>><a href="<?php echo $tpl['link']('maintenance'); ?>"><?php echo __('Maintenance'); ?></a></li>
					<li<?php if ($tpl['section'] == 'update') : ?> class="current"<?php endif; ?>><a href="<?php echo $tpl['link']('update'); ?>"><?php echo __('Mise à jour'); ?></a></li>
				</ul>
			</nav>
			<nav>
				<h1><?php echo __('Informations'); ?></h1>
				<ul>
					<li<?php if ($tpl['section'] == 'logs') : ?> class="current"<?php endif; ?>><a href="<?php echo $tpl['link']('logs'); ?>"><?php echo __('Activité'); ?></a></li>
					<li<?php if ($tpl['section'] == 'system') : ?> class="current"<?php endif; ?>><a href="<?php echo $tpl['link']('system'); ?>"><?php echo __('Système'); ?></a></li>
					<li<?php if ($tpl['section'] == 'errors') : ?> class="current"<?php endif; ?>><a href="<?php echo $tpl['link']('errors'); ?>"><?php echo __('Incidents'); ?></a></li>
				</ul>
			</nav>
		</div>
		</div>

		<div id="content">
			<header>
				<div id="header_section">
					<a rel="menu" class="js_menu_link" id="menu_link" href="javascript:;"><img title="<?php echo __('Menu'); ?>" alt="<?php echo __('Menu'); ?>" src="<?php echo $tpl['admin']['style']['path']; ?>/icons/24x24/menu.png" height="24" width="24"></a>
					<a id="dashboard_link" href="<?php echo $tpl['link']('dashboard'); ?>"><img title="<?php echo __('Tableau de bord'); ?>" alt="<?php echo __('Tableau de bord'); ?>" src="<?php echo $tpl['admin']['style']['path']; ?>/icons/24x24/home.png" height="24" width="24"></a>
					<h2><a href="<?php echo $tpl['page']['link']; ?>"><?php echo $tpl['page']['title']; ?></a></h2>
				</div>
				<div class="js_box" id="user_box">
					<a rel="header_links" class="connect_avatar js_box_link" href="javascript:;"><img alt="avatar" src="<?php echo $tpl['auth']['avatar']['thumb']['url']; ?>"></a>
					<div class="js_box_inner" id="header_links">
						<a id="user_login" href="<?php echo $tpl['link']('user/' . $tpl['auth']['id']); ?>"><?php echo $tpl['auth']['nickname']; ?></a>
						<a class="connect_avatar" href="<?php echo $tpl['link']('user-avatar/' . $tpl['auth']['id']); ?>"><img alt="avatar" src="<?php echo $tpl['auth']['avatar']['thumb']['url']; ?>"></a>
<?php if ($tpl['cookie']['session_expire']) : ?>
						<img width="16" height="16" title="<?php printf(__('Votre session expire au bout de %s heures d\'inactivité.'), ($tpl['session']['expire'] / 3600)); ?>" alt="cookie" src="<?php echo $tpl['admin']['style']['path']; ?>/icons/16x16/cookie-chocolate.png">
<?php else : ?>
						<img width="16" height="16" title="<?php echo __('Votre session expire à la fermeture du navigateur.'); ?>" alt="cookie" src="<?php echo $tpl['admin']['style']['path']; ?>/icons/16x16/cookie.png">
<?php endif; ?>
						<a id="user_logout" href="<?php echo $tpl['link']('logout'); ?>"><?php echo __('Déconnexion'); ?></a>
						<span id="gallery_view"><a class="ex" href="<?php echo $tpl['gallery']['path']; ?>/"><?php echo __('Galerie'); ?></a></span>
					</div>
				</div>
			</header>

			<main>
<?php include($tpl['template']['file']); ?>
<?php include('report.tpl.php'); ?>
			</main>

			<div id="debug">
<?php $tpl['print']('logs'); ?>
<?php $tpl['print']('errors'); ?>
			</div>

<?php if ($tpl['help']) : ?>
			<div id="help" data-text-link="<?php echo __('Obtenir de l\'aide sur cette fonction'); ?>">
				<?php include($tpl['help']); ?>
			</div>
<?php endif; ?>

			<footer>
				<p>
<?php if ($tpl['time']()) : ?>
					<span id="footer_time"><?php echo $tpl['time'](); ?></span>
<?php endif; ?>
					<?php printf(__('Propulsé par %s'), '<a rel="noreferrer" class="ex" href="' . $tpl['app']['website'] . '">' . $tpl['app']['name'] . '</a>'); ?>
					<span id="footer_sep">-</span>
					<span id="footer_icons"><?php echo __('Icônes :'); ?> <a rel="noreferrer" class="ex" href="https://p.yusukekamiyamane.com/">Fugue</a></span>
				</p>
			</footer>
		</div>
	</div>

<?php $tpl['print']('sql'); ?>
</body>

</html>