<div>
	<div id="obj_grid_res" class="report_classic">
		<div class="report_msg report_info">
			<p><?php echo __('La largeur de votre écran doit être supérieure ou égale à 1400 pixels pour profiter de toutes les fonctionnalités de ce mode d\'affichage.'); ?></p>
		</div>
	</div>
	<div class="tools">
		<div><span class="icon icon_options show_tool"><a data-id="options" class="js" href="javascript:;"><?php echo __('Options d\'affichage'); ?></a></span></div>
		<span class="sep">-</span>
		<div><span class="icon icon_select show_tool"><a data-id="selection" class="js" href="javascript:;"><?php echo __('Sélection'); ?></a></span></div>
	</div>
	<form action="<?php echo $tpl['current_url_pageless']; ?>" method="post" class="tool" id="options">
		<fieldset>
			<p class="field">
				<label for="grid_lines"><?php echo __('Nombre de lignes de vignettes :'); ?></label>
				<select name="grid_lines" id="grid_lines" class="focus">
<?php for ($n = 1; $n <= 20; $n++) : ?>
					<option<?php if ($tpl['options']['grid_lines'] == $n) : ?> selected<?php endif; ?> value="<?php echo $n; ?>"><?php echo $n; ?></option>
<?php endfor; ?>
				</select>
			</p>
			<p class="field">
				<label for="order_by_column"><?php echo __('Trier par :'); ?></label>
				<select name="order_by_column" id="order_by_column">
<?php foreach ($tpl['options']['grid_order_by_column'] as &$i) : ?>
					<option<?php if ($i['selected']) : ?> selected<?php endif; ?> value="<?php echo $i['value']; ?>"><?php echo $i['text']; ?></option>
<?php endforeach; ?>
				</select>
				<select name="order_by_order">
<?php foreach ($tpl['options']['grid_order_by_order'] as &$i) : ?>
					<option<?php if ($i['selected']) : ?> selected<?php endif; ?> value="<?php echo $i['value']; ?>"><?php echo $i['text']; ?></option>
<?php endforeach; ?>
				</select>
			</p>
			<p class="field">
				<label for="grid_tb_size"><?php echo __('Taille des vignettes :'); ?></label>
				<select name="grid_tb_size" id="grid_tb_size">
<?php foreach (CONF_THUMBS_GRID_SIZES as $k => $n) : ?>
					<option<?php if ($tpl['options']['grid_tb_size'] == $n) : ?> selected<?php endif; ?> value="<?php echo $n; ?>"><?php echo $k+1; ?></option>
<?php endforeach; ?>
				</select>
			</p>
		</fieldset>
	</form>

	<form action="<?php echo $tpl['current_url_pageless']; ?>" method="post" class="tool" id="selection">
		<fieldset>
			<p class="field">
				<?php echo __('Série :'); ?>
				<a id="selection_section_all" class="focus js" href="javascript:;"><?php echo __('Tout sélectionner'); ?></a>
				<span class="sep">-</span>
				<a id="selection_section_none" class="js" href="javascript:;"><?php echo __('Tout désélectionner'); ?></a>
				<span class="sep">-</span>
				<a id="selection_section_invert" class="js" href="javascript:;"><?php echo __('Inverser la sélection'); ?></a>
			</p>
			<p class="field">
				<?php echo __('Page :'); ?>
				<a id="selection_page_all" class="js" href="javascript:;"><?php echo __('Tout sélectionner'); ?></a>
				<span class="sep">-</span>
				<a id="selection_page_none" class="js" href="javascript:;"><?php echo __('Tout désélectionner'); ?></a>
				<span class="sep">-</span>
				<a id="selection_page_invert" class="js" href="javascript:;"><?php echo __('Inverser la sélection'); ?></a>
			</p>
		</fieldset>
	</form>

<?php include('grid_pagination.tpl.php'); ?>

	<div id="obj_grid_container">
		<form id="obj_grid_form" action="<?php echo $tpl['current_url']; ?>" method="post">
			<div class="loading" id="obj_grid_loading"></div>
			<div id="obj_grid_js">
				<div class="report_classic">
					<div class="report_msg report_info">
						<p><?php echo __('JavaScript doit être activé pour utiliser ce mode d\'affichage.'); ?></p>
					</div>
				</div>
				<input name="anticsrf" type="hidden" value="<?php echo $tpl['anticsrf'](); ?>">
				<input name="display" type="hidden" value="list">
				<input name="options" type="hidden" value="1">
				<input type="submit" value="<?php echo __('Revenir au mode d\'affichage en liste'); ?>">
			</div>
			<script nonce="<?php echo CSP_NONCE; ?>" type="text/javascript">
			document.getElementById('obj_grid_loading').style.display = 'block';
			document.getElementById('obj_grid_js').style.display = 'none';
			</script>
		</form>
	</div>

<?php include('grid_pagination.tpl.php'); ?>
</div>

<script nonce="<?php echo CSP_NONCE; ?>" type="text/javascript">
var l10n_report_error = "<?php echo $tpl['php2js'](Report::getErrorDefaultMessage()); ?>";
var l10n_report_nochange = "<?php echo $tpl['php2js'](Report::getNoCHangeDefaultMessage()); ?>";
var l10n_report_success = "<?php echo $tpl['php2js'](Report::getSuccessDefaultMessage()); ?>";
</script>