<?php $confirm_delete = __('Supprimer les catégories sélectionnées ?'); ?>
<?php if (isset($_POST['action']) && in_array($_POST['action'], ['move_confirm', 'owner_confirm'])) : ?>
<form id="action_selection" action="<?php echo $tpl['current_url']; ?>" method="post">
	<div>
		<p class="field"><?php printf(__('Sélection : %s'), count($_POST['selected'] ?? [])); ?></p>
		<p class="field">
<?php if ($_POST['action'] == 'move_confirm') : ?>
			<label for="list_categories"><?php echo __('Catégorie parente :'); ?></label>
			<select autofocus id="list_categories" name="cat_id">
				<?php foreach ($tpl['categories_move'] as &$i) : ?><?php if ($i['node'] == 'content' && $i['type'] == 'category') : ?><option value="<?php echo $i['id']; ?>"><?php echo str_repeat(' ', $i['level'] * 4); ?><?php echo $i['title']; ?></option><?php endif; ?><?php endforeach; ?>

			</select>
<?php else : ?>
			<label for="list_users"><?php echo __('Nouveau propriétaire :'); ?></label>
			<select autofocus id="list_users" name="user_id">
<?php foreach ($tpl['users'] as &$i) : ?>
				<option value="<?php echo $i['id']; ?>"><?php echo $i['nickname']; ?></option>
<?php endforeach; ?>
			</select>
<?php endif; ?>
		</p>
<?php if (!empty($_POST['selected'])) : ?>
<?php foreach ($_POST['selected'] as $id => &$value) : ?>
		<input name="selected[<?php echo $id; ?>]" type="hidden" value="<?php echo $value; ?>">
<?php endforeach; ?>
<?php endif; ?>
		<input name="anticsrf" type="hidden" value="<?php echo $tpl['anticsrf'](); ?>">
		<input name="action" type="hidden" value="<?php echo str_replace('_confirm', '', $_POST['action']); ?>">
		<input name="selection" type="submit" value="<?php echo __('Valider'); ?>">
		<input name="cancel" type="submit" value="<?php echo __('Annuler'); ?>">
	</div>
</form>
<?php elseif (isset($_POST['action']) && $_POST['action'] == 'delete_confirm') : ?>
<?php include('delete_selection.tpl.php'); ?>
<?php else : ?>

<div id="tools_display">
	<div class="tools">
		<div><span class="icon icon_category_add show_tool"><a data-id="category_add" class="js<?php if ($_GET['section_1'] == 'category-add') : ?> show<?php endif; ?>" href="<?php echo $tpl['link']('category' . (strstr($_GET['section_1'], 'add') ? '' : '-add') . '/' . $tpl['category']['id'] . '/page/' . $_GET['page']); ?>"><?php echo __('Nouvelle catégorie'); ?></a></span></div>
		<span class="sep">-</span>
		<div><span class="icon icon_search show_tool"><a data-id="search" class="js<?php if (strstr($_GET['section_1'], 'search')) : ?> show<?php endif; ?>" href="<?php echo $_GET['section'] == 'category' ? $tpl['link']('category' . (strstr($_GET['section_1'], 'search') ? '' : '-search') . '/' . $tpl['category']['id'] . '/page/' . $_GET['page']) : 'javascript:;'; ?>"><?php echo __('Recherche'); ?></a></span></div>
<?php if ($tpl['options']['display'] == 'list') : ?>
		<span class="sep">-</span>
		<div><span class="icon icon_options show_tool"><a data-id="options" class="js<?php if (strstr($_GET['section_1'], 'display')) : ?> show<?php endif; ?>" href="<?php echo $_GET['section'] == 'category' ? $tpl['link']('category' . (strstr($_GET['section_1'], 'display') ? '' : '-display') . '/' . $tpl['category']['id'] . '/page/' . $_GET['page']) : 'javascript:;'; ?>"><?php echo __('Options d\'affichage'); ?></a></span></div>
<?php endif; ?>
	</div>
	<div id="display">
		<a id="display_list" class="display_link<?php if ($tpl['options']['display'] == 'list') : ?> current<?php endif; ?>" href="javascript:;" title="<?php echo __('Liste'); ?>"><img src="<?php echo $tpl['admin']['style']['path']; ?>/icons/20x20/display-list.png"></a>
		<a id="display_grid" class="display_link<?php if ($tpl['options']['display'] == 'grid') : ?> current<?php endif; ?>" href="javascript:;" title="<?php echo __('Grille'); ?>"><img src="<?php echo $tpl['admin']['style']['path']; ?>/icons/20x20/display-grid.png"></a>
		<form action="<?php echo $tpl['current_url_pageless']; ?>" method="post">
			<input name="options" type="hidden" value="">
			<input name="display" type="hidden" value="">
			<input name="anticsrf" type="hidden" value="<?php echo $tpl['anticsrf'](); ?>">
		</form>
	</div>
</div>

<form action="<?php echo $tpl['current_url_pageless']; ?>" method="post" class="tool<?php if ($_GET['section_1'] == 'category-add') : ?> show<?php endif; ?>" id="category_add">
	<fieldset>
		<p class="field">
			<?php echo __('Type :'); ?>
			&nbsp;
			<input name="type" value="category" id="new_category_type_cat" type="radio">
			<label for="new_category_type_cat"><?php echo __('Catégorie'); ?></label>
			&nbsp;
			<input checked name="type" value="album" id="new_category_type_alb" type="radio">
			<label data-help-icon="new_category" for="new_category_type_alb"><?php echo __('Album'); ?></label>
		</p>
		<p class="field">
			<label for="new_category_title"><?php echo __('Titre :'); ?></label>
			<input<?php if ($_GET['section_1'] == 'category-add') : ?> autofocus<?php endif; ?> required maxlength="128" value="" name="title" id="new_category_title" type="text" class="focus large">
		</p>
		<p class="field">
			<input checked id="new_category_activate" type="checkbox" name="activate">
			<label for="new_category_activate"><?php echo __('Activer la catégorie'); ?></label>
		</p>
		<input name="anticsrf" type="hidden" value="<?php echo $tpl['anticsrf'](); ?>">
		<input name="new_category" type="submit" value="<?php echo __('Valider'); ?>">
	</fieldset>
</form>

<?php if ($tpl['options']['display'] == 'list') : ?>
<form action="<?php echo str_replace('-display', '', $tpl['current_url_pageless']); ?>" method="post" class="tool<?php if ($_GET['section_1'] == 'category-display') : ?> show<?php endif; ?>" id="options">
	<fieldset>
		<p class="field">
			<label for="nb_per_page"><?php echo __('Nombre de catégories par page :'); ?></label>
			<input<?php if ($_GET['section_1'] == 'category-display') : ?> autofocus<?php endif; ?> required maxlength="3" size="3" value="<?php echo $tpl['options']['nb_per_page']; ?>" name="nb_per_page" id="nb_per_page" type="text" class="focus">
		</p>
		<p class="field">
			<label for="order_by_column"><?php echo __('Trier par :'); ?></label>
			<select name="order_by_column" id="order_by_column">
<?php foreach ($tpl['options']['order_by_column'] as &$i) : ?>
				<option<?php if ($i['selected']) : ?> selected<?php endif; ?> value="<?php echo $i['value']; ?>"><?php echo $i['text']; ?></option>
<?php endforeach; ?>
			</select>
			<select name="order_by_order">
<?php foreach ($tpl['options']['order_by_order'] as &$i) : ?>
				<option<?php if ($i['selected']) : ?> selected<?php endif; ?> value="<?php echo $i['value']; ?>"><?php echo $i['text']; ?></option>
<?php endforeach; ?>
			</select>
		</p>
		<p class="field">
			<label for="thumbs_size"><?php echo __('Taille des vignettes :'); ?></label>
			<select name="thumbs_size" id="thumbs_size">
<?php foreach ($tpl['options']['thumbs_size'] as &$i) : ?>
				<option<?php if ($i['selected']) : ?> selected<?php endif; ?> value="<?php echo $i['value']; ?>"><?php echo $i['text']; ?></option>
<?php endforeach; ?>
			</select>
		</p>
		<input name="anticsrf" type="hidden" value="<?php echo $tpl['anticsrf'](); ?>">
		<input name="options" type="submit" value="<?php echo __('Valider'); ?>">
	</fieldset>
</form>
<?php endif; ?>

<?php include('albums_search.tpl.php'); ?>

<?php if ($tpl['objects_count'] > 0) : ?>
<?php include('category_' . $tpl['options']['display'] . '.tpl.php'); ?>

<?php else : ?>
<br>
<div class="report_classic">
	<div class="report_msg report_info">
		<p><?php echo (isset($_GET['search'])) ? __('Aucune catégorie trouvée.') : ($_GET['category_id'] > 1 ? __('La catégorie ne contient aucun élément.') : __('La galerie ne contient aucun élément.')); ?></p>
	</div>
</div>
<br><br>
<?php endif; ?>

<?php endif; ?>
