## Tips for protecting your privacy

If you attach great importance to your privacy and still want to participate in Fediverse, you need to think carefully about what you want to reveal about yourself before and during the creation of a personal channel. This is the case with every Fediverse service. With Hubzilla, however, there is another important aspect. You not only have to ask yourself the question ‘What?’, but also ‘To whom?’ and ‘Which?’.

With Hubzilla, you not only determine what you disclose about yourself, but also who you allow to see the information and content. And who you allow to interact with what.

The advantage is that you are not dependent on a ‘rule set’, but can define different rules for different applications and different contacts.

A typical use case would be that you want to participate in Fediverse in the normal way that you are familiar with from other social networks.

When creating a channel, you must make the first relevant decision: **the channel role**.

Here you can choose between ‘Public’, ‘Personal’, ‘Community Forum’ and ‘ Customised’.

Apart from the ‘Community Forum’, which is intended for other applications, you have the choice between three roles.

1. With the ‘Public’ role, you allow others to
   1. see your channel stream (i.e. the posts that you share publicly) and your posts in general,
   2. see your standard profile,
   3. see your connections,
   4. see your file and image folders,
   5. see the web pages of your channel,
   6. see the wiki pages of your channel,
   7. comment on, like or dislike your posts,
   8. send you direct messages,
   9. like or dislike your profiles and profile content and
   10. chat with you.

These role-based rules reflect the ‘normal’ use of a social network quite well.

1. The ‘Personal’ role is similar and only denies some of the permissions of the ‘Public’ role. It allows others to
   1. see your channel stream (i.e. the posts that you share publicly) and your posts in general,
   2. see your default profile,
   3. ./.
   4. see your file and image folders,
   5. see the web pages of your channel,
   6. see the wiki pages of your channel,
   7. ./.
   8. ./.
   9. ./.
   10. ./.

Interaction by other users is restricted with this profile, as they are not allowed to comment on, like or dislike your posts (the latter also not in relation to your profile/profile content). They are also not allowed to send you direct messages or chat with you.

The ‘User-defined’ role allows you to define all authorisations individually. Caution is advised here, as inappropriate rules can make a channel halfway ‘unusable’.

For the intended use as a ‘typical social network account’, we recommend selecting the ‘Public’ or ‘Personal’ role.

If you would rather opt for the ‘Personal’ role, but would still like to allow further interaction with certain users (friends, family, colleagues, etc.), you do not have to use the ‘Public’ role.

Hubzilla works with whitelists (permission lists) for authorisations. The channel role therefore defines the basic authorisations. You cannot subsequently revoke these (apart from defining access rights in the specific individual case of a content) using other mechanisms.

However, you can add various authorisations to the whitelist using different **contact roles**. For example, you could create a ‘Family’ contact role in which - in addition to the authorisations granted by the ‘Personal’ role - further authorisations (e.g. commenting, linking, disliking and sending direct messages) are granted. If you now assign this contact role to your contacts that you define as ‘Family’ in this example, your family members - unlike everyone else - can write comments, give you a thumbs up or thumbs down and communicate with you non-publicly (direct message).

You can create as many contact roles as you like for different purposes and contacts and grant additional authorisations in addition to those of the channel role. But(!): You cannot revoke any authorisation from the channel role there.

It is therefore advisable not to be too generous with the channel role and to select it accordingly, depending on the purpose of the channel. By selecting ‘User-defined’, for example, you could define an even more restrictive channel role than ‘Personal’ and then define further authorisations for certain users with the contact roles (only recommended if you are really familiar with the authorisation system).

Another aspect of privacy is the **profile** information. For ‘typical’ use as a social network account, some information should be disclosed in the profile. Otherwise, other users will not have the idea of connecting with you. Or they want to connect with another user, but the other user refuses because they have no information about you (unless they know you and your channel name). So some information should go in there.

As much as necessary, as little as possible.

You should fill your standard profile, which every channel has, with information according to exactly this principle.

However, Hubzilla allows you to create multiple profiles. In such profiles, you can then enter further information that may be of interest for certain connections. You then have the option of releasing such special profiles for certain connections. The information is therefore not visible and public to everyone, but is only available to the selected users.
