### Channel roles

When you create a new channel, you will be asked to select an permission role depending on how you want to use this channel. The most popular permission roles are the social network roles. You have many more choices comparable to Facebook groups and pages, collaborative spaces, news feeds and more. These roles automatically configure various system variables, from the permissions granted to friends to the default privacy and visibility settings. Advanced configurations are available to customise each of these parameters to your needs, but our experience has been that most users prefer to set it and forget it. Below are some of the different roles that are currently available and how they affect your privacy and interaction options.

**There are four channel roles:**

- Public
- Personal
- Community Forum
- Customised

#### Public

The channel is a very permissive social network profile that is compatible with other federated social networks. Privacy is a lower priority than ease of access and connection with others. Anyone on the network can comment on your public posts and send you private messages. By default, posts and published articles are public, but you can override and restrict this when you create the article. You are listed in the directory. Your online presence and connections are visible to others. This mode can increase your susceptibility to unsolicited messages and spam. The ‘classic’ social media account.

#### Personal

By default, posts and published items are public, but you can override and restrict this when creating the item. You are listed in the directory. Your online presence and connections are visible to others. Only your direct connections can comment on your public posts and send you private messages.

#### Community Forum

The channel is a typical forum. By default, posts and published articles are public. Members can post articles via !mention or wall-to-wall. The posting of photos and other published articles is blocked. The channel is visible in the directory. Members are added automatically.

In order to be able to view media as a forum user, some of which may have restricted authorisations, it is necessary to activate the option ‘Enable OCAP access’ in your own user channel under Settings → Privacy settings (`<hub>/settings/privacy`).

#### Custom

This is the most precise setting for channel rights. All rights can be set in fine granularity. Caution: If you select the wrong settings here, you can render your channel unusable. Fortunately, the rights can also be changed again so that such malfunctions can be rectified. It makes sense to consider the effects of each individual permission for yourself as the channel owner, but also for other users.

**The following settings are possible for each control point:**

- Only me
- Only those you explicitly authorise
- Accepted connections
- Any connections
- Everyone on this website
- All Hubzilla members
- Anyone authenticated
- Anyone on the Internet

To edit the **custom role**, select ‘Privacy settings’ in the settings. At the bottom right you will find the button ‘Custom channel role configuration’. If you click on it, a warning dialogue will appear, drawing your attention to the risks of incorrect configuration. If you confirm that you want to edit the rights, the settings dialogue for the user-defined role rights opens.
