        function update_chart() {
        myChart.update();
    }

    function get_server_data() {
        let get_args = {"graph_type": graph_type};
        var jqxhr = $.get("graph_xml.php", get_args, function (data) {
            jd = JSON.parse(data);
            myChart.data.labels.push(jd.CURTIME);
            myChart.data.datasets[0].data.push(jd.BPS_IN);
            myChart.data.datasets[1].data.push(jd.BPS_OUT);
            myChart.data.datasets[2].data.push(jd.SSL_BPS_IN);
            myChart.data.datasets[3].data.push(jd.SSL_BPS_OUT);
			myChart.data.datasets[4].data.push(jd.PLAINCONN);
			myChart.data.datasets[5].data.push(jd.SSLCONN);
			myChart.data.datasets[6].data.push(jd.REQ_PROCESSING);
            myChart.data.datasets[7].data.push(jd.REQ_PER_SEC);
			myChart.data.datasets[8].data.push(jd.STATIC_HITS_PER_SEC);
			myChart.data.datasets[9].data.push(jd.CACHE_HITS_PER_SEC);
            $('#label_REQ_PROCESSING').text(jd.REQ_PROCESSING);
            $('#label_REQ_PER_SEC').text(jd.REQ_PER_SEC);
            $('#label_TOT_REQS').text(jd.TOT_REQS);
            $('#label_TOTAL_STATIC_HITS').text(jd.TOTAL_STATIC_HITS);
            $('#label_STATIC_HITS_PER_SEC').text(jd.STATIC_HITS_PER_SEC);
            $('#label_TOTAL_CACHE_HITS').text(jd.TOTAL_CACHE_HITS);
            $('#label_CACHE_HITS_PER_SEC').text(jd.CACHE_HITS_PER_SEC);
            $('#label_TOTAL_PRIVATE_CACHE_HITS').text(jd.TOTAL_PRIVATE_CACHE_HITS);
            $('#label_PRIVATE_CACHE_HITS_PER_SEC').text(jd.PRIVATE_CACHE_HITS_PER_SEC);
            $('#label_AVAILCONN').text(jd.AVAILCONN);
            $('#label_PLAINCONN').text(jd.PLAINCONN);
            $('#label_MAXCONN').text(jd.MAXCONN);
            $('#label_AVAILSSL').text(jd.AVAILSSL);
            $('#label_SSLCONN').text(jd.SSLCONN);
            $('#label_MAXSSL_CONN').text(jd.MAXSSL_CONN);

            update_chart();
        })
                .fail(function () {
                    console.log('AJAX fail');
                });
    }


    function get_vh_data() {
        let get_args = {"graph_type": graph_type, "vhost": vhost};
        var jqxhr = $.get("graph_xml.php", get_args, function (data) {
            jd = JSON.parse(data);
            myChart.data.labels.push(jd.CURTIME);
            myChart.data.datasets[0].data.push(jd.REQ_PROCESSING); 
            myChart.data.datasets[1].data.push(jd.REQ_PER_SEC);    
            myChart.data.datasets[2].data.push(jd.STATIC_HITS_PER_SEC);
            myChart.data.datasets[3].data.push(jd.CACHE_HITS_PER_SEC); 
            myChart.data.datasets[4].data.push(jd.EAP_INUSE);
            myChart.data.datasets[5].data.push(jd.EAP_IDLE);
            myChart.data.datasets[6].data.push(jd.EAP_WAITQ);
            myChart.data.datasets[7].data.push(jd.EAP_REQ_PER_SEC); // EAP_REQ_PER_SEC
            $('#label_TOTAL_STATIC_HITS').text(jd.TOTAL_STATIC_HITS);
            $('#label_REQ_PROCESSING').text(jd.REQ_PROCESSING);
            $('#label_REQ_PER_SEC').text(jd.REQ_PER_SEC);
            $('#label_TOT_REQS').text(jd.TOT_REQS);
            $('#label_TOTAL_STATIC_HITS').text(jd.TOTAL_STATIC_HITS);
            $('#label_STATIC_HITS_PER_SEC').text(jd.STATIC_HITS_PER_SEC);
            $('#label_TOTAL_CACHE_HITS').text(jd.TOTAL_CACHE_HITS);
            $('#label_CACHE_HITS_PER_SEC').text(jd.CACHE_HITS_PER_SEC);
            $('#label_TOTAL_PRIVATE_CACHE_HITS').text(jd.TOTAL_PRIVATE_CACHE_HITS);
            $('#label_PRIVATE_CACHE_HITS_PER_SEC').text(jd.PRIVATE_CACHE_HITS_PER_SEC);
            $('#label_EAP_PROCESS').text(jd.EAP_PROCESS);
            $('#label_PLAINCONN').text(jd.PLAINCONN);
            $('#label_EAP_INUSE').text(jd.EAP_INUSE);
            $('#label_EAP_IDLE').text(jd.EAP_IDLE);
            $('#label_EAP_WAITQ').text(jd.EAP_WAITQ);
            $('#label_EAP_REQ_PER_SEC').text(jd.EAP_REQ_PER_SEC);

            update_chart();
        })
                .fail(function () {
                    console.log('AJAX fail');
                });
    }

    function get_extapp_data() {
        let get_args = {"graph_type": graph_type, "vhost": vhost, "extapp": extapp};
        var jqxhr = $.get("graph_xml.php", get_args, function (data) {
            jd = JSON.parse(data);

            myChart.data.labels.push(jd.CURTIME);
            myChart.data.datasets[0].data.push(jd.INUSE_CONN);
			myChart.data.datasets[1].data.push(jd.IDLE_CONN);
            myChart.data.datasets[2].data.push(jd.WAITQUEUE_DEPTH);
            myChart.data.datasets[3].data.push(jd.REQ_PER_SEC);
            $('#label_CONFIG_MAX_CONN').text(jd.CONFIG_MAX_CONN);
            $('#label_EFFECT_MAX_CONN').text(jd.EFFECT_MAX_CONN);
            $('#label_POOL_SIZE').text(jd.POOL_SIZE);
            $('#label_INUSE_CONN').text(jd.INUSE_CONN);
            $('#label_IDLE_CONN').text(jd.IDLE_CONN);
            $('#label_WAITQUEUE_DEPTH').text(jd.WAITQUEUE_DEPTH);
            $('#label_REQ_PER_SEC').text(jd.REQ_PER_SEC);
            update_chart();
        })
                .fail(function () {
                    console.log('AJAX fail');
                });
    }

    function reset_interval(graph_type, seconds) {
        if (graph_type == 'Server') {
            interval_id = setInterval(get_server_data, seconds * 1000);
        } else if (graph_type == 'VH') {
            interval_id = setInterval(get_vh_data, seconds * 1000);
        } else { // EXTAPP
            interval_id = setInterval(get_extapp_data, seconds * 1000);
        }
        return interval_id;
    }


    var ctx = document.getElementById('realtimeChart').getContext('2d');
    var data;

    if (graph_type == 'Server') {
        data = {
            labels: [],
            datasets: [
                {
                    label: 'Http In (KB)',
                    data: [],
                    parsing: {
                        yAxisKey: 'BPS_IN'
                    },
                    borderColor: '#6fe5bf',
                    backgroundColor: '#6fe5bf'
                }, {
                    label: 'Http Out (KB)',
                    data: [],
                    parsing: {
                        yAxisKey: 'BPS_OUT'
                    },
                    borderColor: '#f0a00e',
                    backgroundColor: '#f0a00e'
                }, {
                    label: 'Https In (KB)',
                    data: [],
                    parsing: {
                        yAxisKey: 'SSL_BPS_IN'
                    },
                    borderColor: '#4c8a4a',
                    backgroundColor: '#4c8a4a'
                }, {
                    label: 'Https Out (KB)',
                    data: [],
                    parsing: {
                        yAxisKey: 'SSL_BPS_OUT'
                    },
                    borderColor: '#e7e004',
                    backgroundColor: '#e7e004'
                }, {
                    label: 'Http Used',
                    data: [],
                    parsing: {
                        yAxisKey: 'PLAINCONN'
                    },
                    borderColor: '#fd20b9',
                    backgroundColor: '#fd20b9'
                }, {
                    label: 'Https Used',
                    data: [],
                    parsing: {
                        yAxisKey: 'SSLCONN'
                    },
                    borderColor: '#c23636',
                    backgroundColor: '#c23636'
                }, {
                    label: 'Req in Processing',
                    data: [],
                    parsing: {
                        yAxisKey: 'REQ_PROCESSING'
                    },
                    borderColor: '#70ab44',
                    backgroundColor: '#70ab44'
                }, {
                    label: 'Req/Sec',
                    data: [],
                    parsing: {
                        yAxisKey: 'REQ_PER_SEC'
                    },
                    borderColor: '#9628c6',
                    backgroundColor: '#9628c6',
                }, {
                    label: 'Static Hits/Sec',
                    data: [],
                    parsing: {
                        yAxisKey: 'STATIC_HITS_PER_SEC'
                    },
                    borderColor: '#a4c6e7',
                    backgroundColor: '#a4c6e7'
                }, {
                    label: 'Public Cache Hits/Sec',
                    data: [],
                    parsing: {
                        yAxisKey: 'CACHE_HITS_PER_SEC'
                    },
                    borderColor: '#3f81c3',
                    backgroundColor: '#3f81c3'
                }]
        };

    } else if (graph_type == 'VH') {
        data = {
            labels: [],
            datasets: [
                {
                    label: 'Req in Processing',
                    data: [],
                    parsing: {
                        yAxisKey: 'REQ_PROCESSING'
                    },
                    borderColor: '#70ab44',
                    backgroundColor: '#70ab44'
                }, {
                    label: 'Req/Sec',
                    data: [],
                    parsing: {
                        yAxisKey: 'REQ_PER_SEC'
                    },
                    borderColor: '#9628c6',
                    backgroundColor: '#9628c6'
                }, {
                    label: 'Static Hits/Sec',
                    data: [],
                    parsing: {
                        yAxisKey: 'STATIC_HITS_PER_SEC'
                    },
                    borderColor: '#a4c6e7',
                    backgroundColor: '#a4c6e7'
                }, {
                    label: 'Public Cache Hits/Sec',
                    data: [],
                    parsing: {
                        yAxisKey: 'CACHE_HITS_PER_SEC'
                    },
                    borderColor: '#3f81c3',
                    backgroundColor: '#3f81c3'
                }, {
                    label: 'EAProc In Use',
                    data: [],
                    parsing: {
                        yAxisKey: 'EAP_INUSE'
                    },
                    borderColor: '#009926',
                    backgroundColor: '#009926'
                }, {
                    label: 'EAProc Idle',
                    data: [],
                    parsing: {
                        yAxisKey: 'EAP_IDLE'
                    },
                    borderColor: '#f0a00e',
                    backgroundColor: '#f0a00e'
                }, {
                    label: 'EAProc WaitQ',
                    data: [],
                    parsing: {
                        yAxisKey: 'EAP_WAITQ'
                    },
                    borderColor: '#d13814',
                    backgroundColor: '#d13814'
                }, {
                    label: 'EAProc Req/Sec',
                    data: [],
                    parsing: {
                        yAxisKey: 'EAP_REQ_PER_SEC'
                    },
                    borderColor: '#6808d1',
                    backgroundColor: '#6808d1'
                }]
        };

    } else if (graph_type == 'EXTAPP') {
        data = {
            labels: [],
            datasets: [
                {
                    label: 'In Use Conn',
                    data: [],
                    parsing: {
                        yAxisKey: 'INUSE_CONN'
                    },
                    borderColor: '#009926',
                    backgroundColor: '#009926'
                }, {
                    label: 'Idle Conn',
                    data: [],
                    parsing: {
                        yAxisKey: 'IDLE_CONN'
                    },
                    borderColor: '#f0a00e',
                    backgroundColor: '#f0a00e'
                }, {
                    label: 'WaitQ',
                    data: [],
                    parsing: {
                        yAxisKey: 'WAITQUEUE_DEPTH'
                    },
                    borderColor: '#d13814',
                    backgroundColor: '#d13814'
                }, {
                    label: 'Req/Sec',
                    data: [],
                    parsing: {
                        yAxisKey: 'REQ_PER_SEC'
                    },
                    borderColor: '#6808d1',
                    backgroundColor: '#6808d1'
                }]
        };


    } else {
        console.log('graph_type error');
    }

    var cfg = {
        type: 'line',
        data: data,
        options: {
            plugins: {
                title: {
                    display: true,
                    text: graph_title,
                    font: {
                        weight: 'bold',
                        size: 24
                    }
                }
            }
        }
    };


    var myChart = new Chart(ctx, cfg);

    $(document).ready(function () {
        let interval_id = reset_interval(graph_type, 15); // initial default to 15 secs

        $('#refresh_period').on('change', function (e) {
            var refresh_val = $('#refresh_period option:selected').val();
            switch (refresh_val) {
                case 'STOP':
                    clearInterval(interval_id);
                    break;
                case '10':
                case '15':
                case '30':
                case '60':
                case '120':
                case '300':
                    clearInterval(interval_id);
                    interval_id = reset_interval(graph_type, refresh_val);
                    break;
                default:
                    console.log('Error: Invalid SELECT Input:#refresh_period option value: ' + refresh_val);
            }

        });
    });

