<?php

class PRODUCT
{

	public $product = null;
	public $version = null;
	public $edition = '';
	public $type = 'LSWS';
	public $tmp_path = null;
	public $processes = 1;
	public $new_release = null;
	public $new_version = null;
	public $cur_build = 0;
	public $installed_releases = [];

	private function __construct()
	{
		$this->init();
	}

	public static function GetInstance()
	{
		if (!isset($GLOBALS['_PRODUCT_'])) {
			$GLOBALS['_PRODUCT_'] = new PRODUCT();
		}
		return $GLOBALS['_PRODUCT_'];
	}

	function init()
	{
		$this->processes = DUtil::grab_input("server", 'LSWS_CHILDREN', 'int');

		$m = [];
		$this->product = 'LiteSpeed Web Server';
		$str = DUtil::grab_input("server", 'LSWS_EDITION');
		if (preg_match('/^(.*)\/(.*)\/(.*)$/i', $str, $m)) {
			$this->edition = strtoupper(trim($m[2]));
			$this->version = trim($m[3]);
		}
		$this->tmp_path = "/tmp/lshttpd/";
	}

	function getInstalled()
	{

		$srt = DUtil::grab_input("server", 'LS_SERVER_ROOT');
		$dir = $srt . 'bin';
		$dh = @opendir($dir);
		if ($dh) {
			while (($fname = readdir($dh)) !== false) {
				$m = [];
				if (preg_match('/^lswsctrl\.(.*)$/', $fname, $m)) {
					$this->installed_releases[] = $m[1];
				}
			}
			closedir($dh);
		}
		$buildfile = $srt . 'BUILD';
		if (file_exists($buildfile)) {
			$this->cur_build = trim(file_get_contents($buildfile));
		}
	}

	function isInstalled($version)
	{
		$state = FALSE;

		foreach ($this->installed_releases as $value) {
			if ($version == $value) {
				return TRUE;
			}
		}

		return $state;
	}

	function refreshVersion()
	{
		$srt = DUtil::grab_input("server", 'LS_SERVER_ROOT');
		$versionfile = $srt . 'VERSION';
		$this->version = trim(file_get_contents($versionfile));
		$buildfile = $srt . 'BUILD';
		if (file_exists($buildfile)) {
			$this->cur_build = trim(file_get_contents($buildfile));
		}
	}

	function getNewVersion()
	{
		$srt = DUtil::grab_input("server", 'LS_SERVER_ROOT');
		$dir = $srt . 'autoupdate';
		$releasefile = $srt . 'autoupdate/release';
		if (file_exists($releasefile)) {
			$this->new_release = trim(file_get_contents($releasefile));
			$m = [];
			if (strpos($this->new_release, '-')) {
				if (preg_match('/^(.*)-/', $this->new_release, $m)) {
					$this->new_version = $m[1];
				}
			} else {
				$this->new_version = $this->new_release;
			}
		}
	}

}
